var Opcodes = Java.type('org.objectweb.asm.Opcodes');
var InsnNode = Java.type('org.objectweb.asm.tree.InsnNode');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');
var MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
var FieldInsnNode = Java.type('org.objectweb.asm.tree.FieldInsnNode');
var JumpInsnNode = Java.type('org.objectweb.asm.tree.JumpInsnNode');
var LabelNode = Java.type('org.objectweb.asm.tree.LabelNode');

var ASMAPI = Java.type('net.minecraftforge.coremod.api.ASMAPI');

function initializeCoreMod() {
	return {
		'getPackedLightCoords': {
			'target': {
				'type': 'METHOD',
				'class': 'net.minecraft.client.renderer.entity.EntityRenderer',
				'methodName': 'm_114505_',
				'methodDesc': '(Lnet/minecraft/world/entity/Entity;F)I'
			},
			'transformer': getPackedLightCoords
		}
	}	
}

function getPackedLightCoords(method) {
	var instructions = method.instructions;
	var returns = 0;

	for (var index = 0; index < instructions.size(); index++)
	{
		var insn = instructions.get(index);
		if (insn instanceof InsnNode && insn.getOpcode() == Opcodes.IRETURN)
		{
			instructions.insertBefore(insn, new VarInsnNode(Opcodes.ALOAD, 1));
			instructions.insertBefore(insn, new VarInsnNode(Opcodes.FLOAD, 2));
			instructions.insertBefore(insn, new MethodInsnNode(Opcodes.INVOKESTATIC, 'com/legacy/lucent/core/asm_hooks/EntityRendererHooks', 'modifyLightColor', '(ILnet/minecraft/world/entity/Entity;F)I'));
			
			index += 3;
			returns++;
		}
	}

	if (returns > 0)
		ASMAPI.log('INFO', '[Lucent] Transformed EntityRenderer.getPackedLightCoords for ' + returns + ' returns');

	return method;
}
