#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;

uniform float GameTime;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec4 normal;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    if (color.a < 0.1) {
        discard;
    }

    float brightness = (color.r + color.g + color.b) / 3.0;
    brightness = clamp(brightness * 2.0, 0, 1);

    color *= vertexColor * ColorModulator;
    vec4 textureColor = color;

    vec2 texCoord1 = vec2(texCoord0.x + (GameTime * 500), texCoord0.y + sin(GameTime * 500));

    vec4 noiseColor = texture(Sampler1, texCoord1) * vec4(1.0, 0.05, 0.05, 1.0);
    noiseColor.rgb *= 0.135;
    noiseColor.a = textureColor.a;
    fragColor = linear_fog((brightness * textureColor) + ((1.0 - brightness) * noiseColor), vertexDistance, FogStart, FogEnd, FogColor);
}
