/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.network;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.OpenTerminalPacket;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.PlayerInvUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("toms_storage", "main"), () -> "2", "2"::equals, "2"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, DataPacket.class, DataPacket::toBytes, DataPacket::new, NetworkHandler::handleData);
        INSTANCE.registerMessage(1, OpenTerminalPacket.class, (a, b) -> {}, b -> new OpenTerminalPacket(), NetworkHandler::handleData);
        StorageMod.LOGGER.info("Initilaized Network Handler");
    }

    public static void handleData(DataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.f_36096_ instanceof IDataReceiver) {
                    ((IDataReceiver)sender.f_36096_).receive(packet.tag);
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                if (Minecraft.m_91087_().f_91080_ instanceof IDataReceiver) {
                    ((IDataReceiver)Minecraft.m_91087_().f_91080_).receive(packet.tag);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static void handleData(OpenTerminalPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack t = PlayerInvUtil.findItem((Player)sender, i -> {
                WirelessTerminal e;
                Item patt2382$temp = i.m_41720_();
                return patt2382$temp instanceof WirelessTerminal && (e = (WirelessTerminal)patt2382$temp).canOpen((ItemStack)i);
            }, ItemStack.f_41583_, Function.identity());
            if (!t.m_41619_()) {
                ((WirelessTerminal)t.m_41720_()).open((Player)sender, t);
            }
        });
    }

    public static void sendDataToServer(CompoundTag tag) {
        INSTANCE.sendToServer((Object)new DataPacket(tag));
    }

    public static void sendTo(ServerPlayer pl, CompoundTag tag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new DataPacket(tag));
    }

    public static void openTerminal() {
        INSTANCE.sendToServer((Object)new OpenTerminalPacket());
    }
}

