/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.ButtonExt;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.InventoryLinkMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.PlatformContainerScreen;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.RemoteConnections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.lwjgl.glfw.GLFW;

public class InventoryLinkScreen
extends PlatformContainerScreen<InventoryLinkMenu>
implements IDataReceiver {
    private static final ResourceLocation gui = new ResourceLocation("toms_storage", "textures/gui/inventory_link.png");
    private static final int LINES = 7;
    private EditBox textF;
    private Map<UUID, RemoteConnections.Channel> connections = new HashMap<UUID, RemoteConnections.Channel>();
    private UUID selected;
    private int beaconLvl;
    private GuiButton createBtn;
    private GuiButton deleteBtn;
    private GuiButton publicBtn;
    private GuiButton remoteBtn;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();
    private List<UUID> sortedList = new ArrayList<UUID>();
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public InventoryLinkScreen(InventoryLinkMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
    }

    @Override
    public void receive(CompoundTag tag) {
        ListTag list = tag.m_128437_("list", 10);
        RemoteConnections.load(list, this.connections);
        if (tag.m_128441_("selected")) {
            this.selected = tag.m_128342_("selected");
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.textF.m_94144_(ch.displayName);
        } else {
            this.selected = null;
        }
        this.remoteBtn.setState(tag.m_128471_("remote") ? 1 : 0);
        this.beaconLvl = tag.m_128451_("lvl");
        Comparator<Map.Entry> cmp = Comparator.comparing(e -> ((RemoteConnections.Channel)e.getValue()).publicChannel);
        cmp = cmp.thenComparing(e -> ((RemoteConnections.Channel)e.getValue()).displayName);
        this.sortedList = this.connections.entrySet().stream().sorted(cmp).map(Map.Entry::getKey).collect(Collectors.toList());
        this.update();
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int x, int y) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(gui, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics st, int p_97809_, int p_97810_) {
        st.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        st.m_280056_(this.f_96547_, I18n.m_118938_((String)"ts.inventory_connector.beacon_level", (Object[])new Object[]{this.beaconLvl}), this.f_97728_, this.f_97729_ + 10, 0x404040, false);
    }

    protected void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.createBtn = this.makeCompositeButton(this.f_97735_ + 121, this.f_97736_ + 24, 0, b -> {
            RemoteConnections.Channel chn = new RemoteConnections.Channel(null, this.publicBtn.getState() == 1, this.textF.m_94155_());
            this.sendEdit(null, chn);
        });
        this.deleteBtn = this.makeCompositeButton(this.f_97735_ + 138, this.f_97736_ + 24, 1, b -> this.sendEdit(this.selected, null));
        this.publicBtn = this.makeCompositeButton(this.f_97735_ + 155, this.f_97736_ + 24, 2, b -> {
            if (this.selected != null && this.connections.containsKey(this.selected)) {
                RemoteConnections.Channel ch = this.connections.get(this.selected);
                if (ch.owner.equals(this.f_96541_.f_91074_.m_20148_())) {
                    ch.publicChannel = !ch.publicChannel;
                    this.publicBtn.setState(ch.publicChannel ? 1 : 0);
                    this.sendEdit(this.selected, ch);
                }
            } else {
                this.publicBtn.setState(this.publicBtn.getState() == 0 ? 1 : 0);
            }
        });
        this.publicBtn.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.link_public_" + s)));
        this.remoteBtn = this.makeCompositeButton(this.f_97735_ + 155, this.f_97736_ + 7, 0, b -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("remote", this.remoteBtn.getState() == 0);
            NetworkHandler.sendDataToServer(tag);
        });
        this.remoteBtn.texY = 32;
        this.remoteBtn.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.link_remote_" + s)));
        Objects.requireNonNull(this.f_96547_);
        this.textF = new EditBox(this.f_96547_, this.f_97735_ + 13, this.f_97736_ + 28, 105, 9, (Component)Component.m_237115_((String)"narrator.toms_storage.inventory_link_channel"));
        this.textF.m_94199_(50);
        this.textF.m_94182_(false);
        this.textF.m_94194_(true);
        this.textF.m_94202_(0xFFFFFF);
        this.textF.m_94144_("");
        this.textF.m_94151_(t -> {
            this.selected = null;
            for (Map.Entry<UUID, RemoteConnections.Channel> e : this.connections.entrySet()) {
                if (!e.getValue().displayName.equals(t)) continue;
                this.selected = e.getKey();
                break;
            }
            this.update();
        });
        this.m_142416_((GuiEventListener)this.textF);
        for (int i = 0; i < 7; ++i) {
            this.listEntries.add(new ListEntry(this.f_97735_ + 12, this.f_97736_ + 42 + i * 16, i));
        }
        this.update();
    }

    public GuiButton.CompositeButton makeCompositeButton(int x, int y, int tile, Button.OnPress pressable) {
        GuiButton.CompositeButton btn = new GuiButton.CompositeButton(x, y, tile, pressable);
        btn.texX = 176;
        btn.texY = 0;
        btn.texture = gui;
        this.m_142416_((GuiEventListener)btn);
        return btn;
    }

    private void sendEdit(UUID id, RemoteConnections.Channel ch) {
        CompoundTag tag = new CompoundTag();
        if (id != null) {
            tag.m_128362_("id", id);
        }
        if (ch != null) {
            ch.saveNet(tag);
        }
        NetworkHandler.sendDataToServer(tag);
    }

    private void sendSelect(UUID id) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", id);
        tag.m_128379_("select", true);
        NetworkHandler.sendDataToServer(tag);
    }

    private void update() {
        if (this.selected != null && this.connections.containsKey(this.selected)) {
            boolean owner;
            this.deleteBtn.f_93623_ = true;
            RemoteConnections.Channel ch = this.connections.get(this.selected);
            this.publicBtn.setState(ch.publicChannel ? 1 : 0);
            this.publicBtn.f_93623_ = owner = ch.owner.equals(this.f_96541_.f_91074_.m_20148_());
            this.createBtn.f_93623_ = false;
        } else {
            this.deleteBtn.f_93623_ = false;
            this.publicBtn.setState(0);
            this.createBtn.f_93623_ = true;
        }
    }

    private boolean needsScrollBars() {
        return this.sortedList.size() > 7;
    }

    public void m_88315_(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(st, mouseX, mouseY, partialTicks);
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) != 0;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 122;
        int l = j + 42;
        int i1 = k + 14;
        int j1 = l + this.sortedList.size() * 16;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        super.m_88315_(st, mouseX, mouseY, partialTicks);
        i = k;
        j = l;
        k = j1;
        this.drawScroll(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), this.needsScrollBars());
        this.m_280072_(st, mouseX, mouseY);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.m_7379_();
            return true;
        }
        if (p_keyPressed_1_ == 258) {
            return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        return !this.textF.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.textF.m_94204_() ? super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textF.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = this.sortedList.size() - 7;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    public class ListEntry
    extends ButtonExt {
        private int id;

        public ListEntry(int x, int y, int id) {
            super(x, y, 106, 16, (Component)Component.m_237119_(), null);
            this.id = id;
            InventoryLinkScreen.this.m_142416_((GuiEventListener)this);
        }

        public void m_87963_(GuiGraphics st, int mouseX, int mouseY, float pt) {
            UUID id;
            if (this.f_93624_ && (id = this.getId()) != null) {
                int x = this.m_252754_();
                int y = this.m_252907_();
                RemoteConnections.Channel chn = InventoryLinkScreen.this.connections.get(id);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)gui);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.f_93622_ = mouseX >= x && mouseY >= y && mouseX < x + this.f_93618_ && mouseY < y + this.f_93619_;
                int i = this.getYImage(this.m_198029_());
                st.m_280218_(gui, x, y, id.equals(InventoryLinkScreen.this.selected) ? 106 : 0, 166 + i * 16, this.f_93618_, this.f_93619_);
                st.m_280218_(gui, x + this.f_93618_ - 16, y, 208 + (chn.publicChannel ? 16 : 0), 0, 16, 16);
                int j = -1;
                st.m_280137_(InventoryLinkScreen.this.f_96547_, chn.displayName, x + this.f_93618_ / 2, y + (this.f_93619_ - 8) / 2, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }
        }

        public void m_5691_() {
            UUID id = this.getId();
            if (id != null) {
                InventoryLinkScreen.this.sendSelect(id);
            }
        }

        private UUID getId() {
            int i = InventoryLinkScreen.this.sortedList.size() - 7;
            int j = (int)((double)(InventoryLinkScreen.this.currentScroll * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < InventoryLinkScreen.this.sortedList.size()) {
                return InventoryLinkScreen.this.sortedList.get(this.id + j);
            }
            return null;
        }
    }
}

