/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class RelicUtils {

    public static class Levelgen {
        public static final List<String> AQUATIC = Arrays.asList(BuiltInLootTables.f_78691_.toString(), BuiltInLootTables.f_78690_.toString(), BuiltInLootTables.f_78695_.toString());
        public static final List<String> NETHER = Arrays.asList(BuiltInLootTables.f_78760_.toString(), BuiltInLootTables.f_78699_.toString(), BuiltInLootTables.f_78698_.toString(), BuiltInLootTables.f_78697_.toString(), BuiltInLootTables.f_78700_.toString(), BuiltInLootTables.f_78701_.toString());
        public static final List<String> COLD = Arrays.asList(BuiltInLootTables.f_78688_.toString(), BuiltInLootTables.f_78757_.toString(), BuiltInLootTables.f_78756_.toString());
        public static final List<String> DESERT = Arrays.asList(BuiltInLootTables.f_78764_.toString(), BuiltInLootTables.f_78754_.toString());
        public static final List<String> CAVE = Arrays.asList(BuiltInLootTables.f_78763_.toString(), BuiltInLootTables.f_78762_.toString(), BuiltInLootTables.f_78761_.toString(), BuiltInLootTables.f_78759_.toString());
        public static final List<String> VILLAGE = Arrays.asList(BuiltInLootTables.f_78754_.toString(), BuiltInLootTables.f_78757_.toString(), BuiltInLootTables.f_78756_.toString(), BuiltInLootTables.f_78755_.toString(), BuiltInLootTables.f_78758_.toString());
    }

    public static class Owner {
        private static final String TAG_OWNER = "owner";

        public static String getOwnerUUID(ItemStack stack) {
            return NBTUtils.getString(stack, TAG_OWNER, "");
        }

        @Nullable
        public static Player getOwner(ItemStack stack, Level world) {
            String uuid = Owner.getOwnerUUID(stack);
            try {
                return world.m_46003_(UUID.fromString(uuid));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static void setOwnerUUID(ItemStack stack, String uuid) {
            NBTUtils.setString(stack, TAG_OWNER, uuid);
        }
    }
}

