/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.inventory;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class InventoryCraftBook
extends TransientCraftingContainer
implements RecipeHolder {
    private Recipe<?> recipeUsed;

    public InventoryCraftBook(AbstractContainerMenu menu) {
        super(menu, 3, 3);
    }

    public ItemStack tryCraft(ItemStack outputItem, NonNullList<ItemStack> craftMatrix, Player player, KitchenMultiBlock multiBlock) {
        int i;
        boolean requireContainer = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(multiBlock, player.m_150109_());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        SourceItem[] sourceItems = new SourceItem[9];
        block1: for (i = 0; i < craftMatrix.size(); ++i) {
            ItemStack ingredient = (ItemStack)craftMatrix.get(i);
            if (ingredient.m_41619_()) continue;
            IngredientPredicateWithCache ingredientPredicate = IngredientPredicateWithCacheImpl.of((it, count) -> ItemStack.m_41656_((ItemStack)it, (ItemStack)ingredient) && count > 0, ingredient);
            for (int j = 0; j < inventories.size(); ++j) {
                IKitchenItemProvider itemProvider = inventories.get(j);
                SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(ingredientPredicate, 1, inventories, requireContainer, true);
                if (sourceItem == null) continue;
                sourceItems[i] = sourceItem;
                continue block1;
            }
        }
        for (i = 0; i < sourceItems.length; ++i) {
            this.m_6836_(i, sourceItems[i] != null ? sourceItems[i].getSourceStack() : ItemStack.f_41583_);
        }
        Level level = player.m_9236_();
        CraftingRecipe craftingRecipe = (CraftingRecipe)CookingRegistry.findFoodRecipe(this, level, RecipeType.f_44107_, outputItem.m_41720_());
        if (craftingRecipe == null || craftingRecipe.m_8043_(level.m_9598_()).m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!craftingRecipe.m_5818_((Container)this, level)) {
            return ItemStack.f_41583_;
        }
        ItemStack result = craftingRecipe.m_5874_((Container)this, level.m_9598_());
        NonNullList remainders = craftingRecipe.m_7457_((Container)this);
        if (!result.m_41619_()) {
            this.fireEventsAndHandleAchievements(player, result);
            for (int i2 = 0; i2 < this.m_6643_(); ++i2) {
                ItemStack restStack;
                IKitchenItemProvider sourceProvider;
                ItemStack itemStack = this.m_8020_(i2);
                if (itemStack.m_41619_() || sourceItems[i2] == null || (sourceProvider = sourceItems[i2].getSourceProvider()) == null) continue;
                ItemStack containerItem = (ItemStack)remainders.get(i2);
                if (sourceItems[i2].getSourceSlot() != -1) {
                    sourceProvider.resetSimulation();
                    sourceProvider.consumeSourceItem(sourceItems[i2], 1, inventories, requireContainer);
                }
                if (containerItem.m_41619_() || (restStack = sourceProvider.returnItemStack(containerItem, sourceItems[i2])).m_41619_() || player.m_150109_().m_36054_(restStack)) continue;
                ItemEntity itemEntity = new ItemEntity(level, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, restStack);
                float motion = 0.05f;
                itemEntity.m_20334_(level.f_46441_.m_188583_() * (double)motion, level.f_46441_.m_188583_() * (double)motion + 0.2, level.f_46441_.m_188583_() * (double)motion);
                level.m_7967_((Entity)itemEntity);
            }
        }
        return result;
    }

    private void fireEventsAndHandleAchievements(Player player, ItemStack result) {
        result.m_41678_(player.m_9236_(), player, 1);
        Balm.getHooks().firePlayerCraftingEvent(player, result, (Container)this);
        this.m_58395_(player, this.m_280657_());
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        this.recipeUsed = recipe;
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return this.recipeUsed;
    }
}

