/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.util.DamageSourceHelper;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class VampiricGloveItem
extends WearableArtifactItem {
    @Override
    public boolean hasNonCosmeticEffects() {
        return ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_RATIO.get() > 0.0 && ModGameRules.VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT.get() > 0 && ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_CHANCE.get() > 0.0;
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_CHANCE.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
    }

    public static void onLivingDamage(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && ModItems.VAMPIRIC_GLOVE.get().isEquippedBy(attacker) && DamageSourceHelper.isMeleeAttack(damageSource)) {
            int maxHealthAbsorbed = ModGameRules.VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT.get();
            double absorptionRatio = ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_RATIO.get();
            double absorptionProbability = ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_CHANCE.get();
            float damageDealt = Math.min(amount, entity.m_21223_());
            float damageAbsorbed = Math.min((float)maxHealthAbsorbed, (float)absorptionRatio * damageDealt);
            if (damageAbsorbed > 0.0f && (double)entity.m_217043_().m_188501_() < absorptionProbability) {
                attacker.m_5634_(damageAbsorbed);
            }
        }
    }
}

