/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.objects;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SpecialLootModifier
extends LootModifier {
    public static final Supplier<Codec<SpecialLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SpecialLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SpecialLootModifier::new)));
    public static final List<ResourceLocation> SUSPICIOUS_TABLES = ImmutableList.of((Object)new ResourceLocation("minecraft", "archaeology/desert_pyramid"), (Object)new ResourceLocation("minecraft", "archaeology/desert_well"), (Object)new ResourceLocation("minecraft", "archaeology/ocean_ruin_cold"), (Object)new ResourceLocation("minecraft", "archaeology/ocean_ruin_warm"), (Object)new ResourceLocation("minecraft", "archaeology/trail_ruins_common"), (Object)new ResourceLocation("minecraft", "archaeology/trail_ruins_rare"));
    public static Omniconfig.DoubleParameter earthHeartChance;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CustomLoot");
        if (builder.config.getSidedType() != Configuration.SidedConfigType.CLIENT) {
            earthHeartChance = builder.comment("The chance for Heart of the Earth to be obtained from suspicious blocks (default is 3%).").getDouble("EarthHeartChance", 0.03);
        }
        builder.popPrefix();
    }

    protected SpecialLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ServerLevel level = context.m_78952_();
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.isVanillaChest(context)) {
                if (OmniconfigHandler.isItemEnabled(EnigmaticItems.ENIGMATIC_EYE) && !SuperpositionHandler.hasPersistentTag((Player)player, "LootedArchitectEye")) {
                    SuperpositionHandler.setPersistentBoolean((Player)player, "LootedArchitectEye", true);
                    generatedLoot.add((Object)new ItemStack((ItemLike)EnigmaticItems.ENIGMATIC_EYE, 1));
                }
                if (SuperpositionHandler.hasPersistentTag((Player)player, "LootedIchorBottle")) {
                    generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticItems.ICHOR_BOTTLE));
                } else if (generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticItems.ICHOR_BOTTLE))) {
                    SuperpositionHandler.setPersistentBoolean((Player)player, "LootedIchorBottle", true);
                }
            }
            if (OmniconfigHandler.isItemEnabled(EnigmaticItems.ASTRAL_FRUIT) && "minecraft:chests/end_city_treasure".equals(String.valueOf(context.getQueriedLootTableId())) && !SuperpositionHandler.hasPersistentTag((Player)player, "LootedFirstEndCityChest")) {
                SuperpositionHandler.setPersistentBoolean((Player)player, "LootedFirstEndCityChest", true);
                if (SuperpositionHandler.isTheCursedOne((Player)player)) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)EnigmaticItems.ASTRAL_FRUIT, 1));
                }
            }
            if (OmniconfigHandler.isItemEnabled(EnigmaticItems.EARTH_HEART) && SUSPICIOUS_TABLES.stream().anyMatch(table -> table.equals((Object)context.getQueriedLootTableId())) && context.m_230907_().m_188500_() < earthHeartChance.getValue()) {
                generatedLoot.clear();
                generatedLoot.add((Object)new ItemStack((ItemLike)EnigmaticItems.EARTH_HEART, 1));
            }
        }
        return generatedLoot;
    }

    private boolean isVanillaChest(LootContext context) {
        return String.valueOf(context.getQueriedLootTableId()).startsWith("minecraft:chests/");
    }

    public Codec<SpecialLootModifier> codec() {
        return CODEC.get();
    }
}

