/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items.generic;

import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;

public abstract class ItemBaseTool
extends DiggerItem
implements ICreativeTabMember {
    public Set<ToolAction> toolActions = Sets.newHashSet();
    public Set<TagKey<Block>> effectiveTags;

    public ItemBaseTool(float attackDamageIn, float attackSpeedIn, Tier tier, Item.Properties builder, Set<TagKey<Block>> effectiveBlocksIn) {
        super(attackDamageIn, attackSpeedIn, tier, (TagKey)effectiveBlocksIn.stream().findAny().get(), builder);
        this.effectiveTags = effectiveBlocksIn;
    }

    public ItemBaseTool(Tier tier) {
        this(4.0f, -2.8f, tier, ItemBaseTool.getDefaultProperties(), Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_}));
    }

    public ItemBaseTool() {
        this(4.0f, -2.8f, EnigmaticMaterials.ETHERIUM, ItemBaseTool.getDefaultProperties(), Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_}));
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockIn) {
        return super.isCorrectToolForDrops(stack, blockIn) || this.hasAnyTag(blockIn, this.effectiveTags);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return !this.hasAnyTag(state, this.effectiveTags) ? super.m_8102_(stack, state) : this.f_40980_;
    }

    protected boolean hasAnyTag(BlockState state, Set<TagKey<Block>> tags) {
        return tags.stream().anyMatch(tag -> this.hasTag(state, (TagKey<Block>)tag));
    }

    protected boolean hasTag(BlockState state, TagKey<Block> tag) {
        return state.m_204336_(tag);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) || this.toolActions.contains(toolAction);
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }

    public static Item.Properties getDefaultProperties() {
        Item.Properties props = new Item.Properties();
        props.m_41487_(1);
        props.m_41497_(Rarity.COMMON);
        return props;
    }
}

