/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class OceanStone
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.PerhapsParameter swimminSpeedBoost;
    public static Omniconfig.PerhapsParameter underwaterCreaturesResistance;
    public static Omniconfig.DoubleParameter xpCostModifier;
    public static Omniconfig.BooleanParameter preventOxygenBarRender;
    public final int xpCostBase = 150;
    public final int nightVisionDuration = 310;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("OceanStone");
        if (builder.config.getSidedType() != Configuration.SidedConfigType.CLIENT) {
            spellstoneCooldown = builder.comment("Active ability cooldown for Will of the Ocean. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 600);
            swimminSpeedBoost = builder.comment("Swimming speed boost provided by Will of the Ocean. Defined as percentage.").max(1000.0).getPerhaps("SwimBoost", 200);
            underwaterCreaturesResistance = builder.comment("Damage resistance against underwater creatures provided by Will of the Ocean. Defined as percentage.").max(100.0).getPerhaps("UnderwaterCreaturesResistance", 40);
            xpCostModifier = builder.comment("Multiplier for experience consumption by active ability of Will of the Ocean.").max(1000.0).getDouble("XPCostModifier", 1.0);
        } else {
            builder.popPrefix();
            preventOxygenBarRender = builder.comment("Whether or not oxygen bar should pe prevented from rendering if Will of the Ocean or Pearl of the Void is equipped.").getBoolean("SuppressUnneccessaryOxygenRender", true);
        }
        builder.popPrefix();
    }

    public OceanStone() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.RARE));
        this.immunityList.add(DamageTypes.f_268722_);
        this.resistanceList.put(DamageTypes.f_268631_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268468_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268546_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268434_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268684_, () -> Float.valueOf(2.0f));
    }

    @Override
    public int getCooldown(Player player) {
        if (player != null && reducedCooldowns.test(player)) {
            return 300;
        }
        return spellstoneCooldown.getValue();
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(Player player) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)((Attribute)ForgeMod.ENTITY_GRAVITY.get()), (Object)new AttributeModifier(UUID.fromString("79e1cc36-fb4e-4c7d-802b-583b8d90648a"), "enigmaticlegacy:gravity_bonus", player.m_204029_(FluidTags.f_13131_) ? -1.0 : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributesDefault;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStoneCooldown", ChatFormatting.GOLD, Float.valueOf((float)this.getCooldown((Player)Minecraft.m_91087_().f_91074_) / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone5", ChatFormatting.GOLD, underwaterCreaturesResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone11");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ChatFormatting.LIGHT_PURPLE, ((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            return;
        }
        if (!(player.m_9236_().m_46472_().m_135782_().toString().equals("minecraft:the_end") || player.m_9236_().m_46472_().m_135782_().toString().equals("minecraft:the_nether") || world.m_6106_().m_6534_())) {
            boolean paybackReceived = false;
            if (ExperienceHelper.getPlayerXP((Player)player) >= this.xpCostBase * 2) {
                ExperienceHelper.drainPlayerXP((Player)player, (int)(((double)this.xpCostBase + Math.random() * (double)this.xpCostBase) * xpCostModifier.getValue()));
                paybackReceived = true;
            }
            if (paybackReceived) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverworld = (ServerLevel)world;
                    int thunderstormTime = (int)(10000.0 + Math.random() * 20000.0);
                    serverworld.m_8606_(0, thunderstormTime, true, true);
                }
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_12090_, SoundSource.NEUTRAL, 2.0f, (float)((double)0.7f + Math.random() * 0.3));
                SuperpositionHandler.setSpellstoneCooldown((Player)player, this.getCooldown((Player)player));
            }
        }
    }

    @Override
    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            EnigmaticItems.MINING_CHARM.removeNightVisionEffect((Player)player, this.nightVisionDuration);
            player.m_21204_().m_22161_(this.createAttributeMap((Player)player));
        }
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        ServerPlayer player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer && SuperpositionHandler.hasCurio((LivingEntity)(player = (ServerPlayer)livingEntity), EnigmaticItems.OCEAN_STONE)) {
            if (player.m_204029_(FluidTags.f_13131_)) {
                EnigmaticEventHandler.isApplyingNightVision = true;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, this.nightVisionDuration, 0, true, false));
                EnigmaticEventHandler.isApplyingNightVision = false;
                player.m_20301_(300);
            } else {
                EnigmaticItems.MINING_CHARM.removeNightVisionEffect((Player)player, this.nightVisionDuration);
            }
            player.m_21204_().m_22178_(this.createAttributeMap((Player)player));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap atts = HashMultimap.create();
        atts.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(UUID.fromString("13faf191-bf38-4654-b369-cc1f4f1143bf"), "Swim speed bonus", swimminSpeedBoost.getValue().asMultiplier(false), AttributeModifier.Operation.MULTIPLY_BASE));
        return atts;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }
}

