/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class MonsterCharm
extends ItemBaseCurio {
    public static Omniconfig.PerhapsParameter undeadDamageBonus;
    public static Omniconfig.PerhapsParameter hostileDamageBonus;
    public static Omniconfig.BooleanParameter bonusLootingEnabled;
    public static Omniconfig.BooleanParameter doubleXPEnabled;
    public float bonusXPModifier = 2.0f;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("MonsterCharm");
        undeadDamageBonus = builder.comment("Damage bonus against undead enemies for Emblem of Monster Slayer. Defined as percentage.").max(1000.0).getPerhaps("UndeadDamage", 25);
        hostileDamageBonus = builder.comment("Damage bonus against agressive creatures for Emblem of Monster Slayer. Defined as percentage.").max(1000.0).getPerhaps("HostileDamage", 10);
        bonusLootingEnabled = builder.comment("Whether or not Emblem of Monster Slayer should provide +1 Looting Level.").getBoolean("BonusLooting", true);
        doubleXPEnabled = builder.comment("Whether or not Emblem of Monster Slayer should provide double experience drop from monsters.").getBoolean("DoubleXP", true);
        builder.popPrefix();
    }

    public MonsterCharm() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm1", ChatFormatting.GOLD, undeadDamageBonus.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm2", ChatFormatting.GOLD, hostileDamageBonus.getValue().asPercentage() + "%");
            if (bonusLootingEnabled.getValue()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm3");
            }
            if (doubleXPEnabled.getValue()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm4");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack curio) {
        return super.getLootingLevel(slotContext, source, target, baseLooting, curio) + 1;
    }
}

