/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.triggers.CursedRingEquippedTrigger;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CursedRing
extends ItemBaseCurio {
    public static Omniconfig.PerhapsParameter painMultiplier;
    public static Omniconfig.PerhapsParameter monsterDamageDebuff;
    public static Omniconfig.PerhapsParameter armorDebuff;
    public static Omniconfig.PerhapsParameter experienceBonus;
    public static Omniconfig.IntParameter fortuneBonus;
    public static Omniconfig.IntParameter lootingBonus;
    public static Omniconfig.IntParameter enchantingBonus;
    public static Omniconfig.PerhapsParameter knockbackDebuff;
    public static Omniconfig.DoubleParameter neutralAngerRange;
    public static Omniconfig.DoubleParameter neutralXRayRange;
    public static Omniconfig.DoubleParameter endermenRandomportRange;
    public static Omniconfig.DoubleParameter endermenRandomportFrequency;
    public static Omniconfig.BooleanParameter saveTheBees;
    public static Omniconfig.BooleanParameter enableSpecialDrops;
    public static Omniconfig.BooleanParameter enableLore;
    public static Omniconfig.BooleanParameter concealAbilities;
    public static Omniconfig.BooleanParameter disableInsomnia;
    public static Omniconfig.BooleanParameter ultraHardcore;
    public static Omniconfig.BooleanParameter autoEquip;
    public static final List<ResourceLocation> neutralAngerBlacklist;
    public static Omniconfig.DoubleParameter superCursedTime;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        String prevCategory = builder.getCurrentCategory();
        builder.popCategory();
        builder.pushCategory("The Seven Curses", "Config options directly affecting Ring of the Seven Curses");
        builder.pushPrefix("CursedRing");
        if (builder.config.getSidedType() == Configuration.SidedConfigType.CLIENT) {
            enableLore = builder.comment("Set to false to disable displaying lore on Ring of the Seven Curses. Useful if you are a modpack developer wanting to have your own.").getBoolean("DisplayLore", true);
            concealAbilities = builder.comment("If true, tooltip of Ring of the Seven Curses cannot be read before it is equipped. Fun way to teach players that not every mystery is worth investigating.").getBoolean("ConcealAbilities", false);
        } else {
            painMultiplier = builder.comment("Defines how much damage bearers of the ring receive from any source. Measured as percentage.").getPerhaps("PainModifier", 200);
            monsterDamageDebuff = builder.comment("How much damage monsters receive from bearers of the ring will be decreased, in percents.").getPerhaps("MonsterDamageDebuff", 50);
            armorDebuff = builder.comment("How much less effective armor will be for those who bear the ring. Measured as percetage.").max(100.0).getPerhaps("ArmorDebuff", 30);
            experienceBonus = builder.comment("How much experience will drop from mobs to bearers of the ring, measured in percents.").getPerhaps("ExperienceBonus", 400);
            fortuneBonus = builder.comment("How many bonus Fortune levels ring provides").getInt("FortuneBonus", 1);
            lootingBonus = builder.comment("How many bonus Looting levels ring provides").getInt("LootingBonus", 1);
            enchantingBonus = builder.comment("How much additional Enchanting Power ring provides in Enchanting Table.").getInt("EnchantingBonus", 10);
            enableSpecialDrops = builder.comment("Set to false to disable ALL special drops that can be obtained from vanilla mobs when bearing Ring of the Seven Curses.").getBoolean("EnableSpecialDrops", true);
            ultraHardcore = builder.comment("If true, Ring of the Seven Curses will be equipped into player's ring slot right away when entering a new world, instead of just being added to their inventory.").getBoolean("UltraHardcore", false);
            autoEquip = builder.comment("If true, Ring of the Seven Curses will be equipped into player's ring slot right away when it enters their inventory. This is different from ultra hardcore option as the way through which ring ends up in player's inventory does not matter.").getBoolean("AutoEquip", false);
            disableInsomnia = builder.comment("Set to true to prevent curse of insomnia from actually doing anything.").getBoolean("disableInsomnia", false);
            knockbackDebuff = builder.comment("How much knockback bearers of the ring take, measured in percents.").getPerhaps("KnockbackDebuff", 200);
            neutralAngerRange = builder.comment("Range in which neutral creatures are angered against bearers of the ring.").min(4.0).getDouble("NeutralAngerRange", 24.0);
            neutralXRayRange = builder.comment("Range in which neutral creatures can see and target bearers of the ring even if they can't directly see them.").getDouble("NeutralXRayRange", 4.0);
            endermenRandomportFrequency = builder.comment("Allows to adjust how frequently Endermen will try to randomly teleport to player bearing the ring, even if they can't see the player and are not angered yet. Lower value = less probability of this happening.").min(0.01).getDouble("EndermenRandomportFrequency", 1.0);
            endermenRandomportRange = builder.comment("Range in which Endermen can try to randomly teleport to bearers of the ring.").min(8.0).getDouble("EndermenRandomportRange", 32.0);
            superCursedTime = builder.comment("A fraction of time the player should bear the Seven Curses to use Abyssal Artifacts.").getDouble("SuperCursedTime", 0.995);
            builder.popCategory();
            builder.pushCategory("Save the Bees", "This category exists solely because of Jusey1z who really wanted to protect his bees." + Configuration.NEW_LINE + "Btw Jusey, when I said 'very cute though', I meant you. Bees are cute either of course.");
            saveTheBees = builder.comment("If true, bees will never affected by the Second Curse of Ring of the Seven Curses.").getBoolean("DontTouchMyBees", false);
            neutralAngerBlacklist.clear();
            neutralAngerBlacklist.add(new ResourceLocation("the_bumblezone", "bee_queen"));
            String[] blacklist = builder.config.getStringList("CursedRingNeutralAngerBlacklist", "The Seven Curses", new String[0], "List of entities that should never be affected by the Second Curse of Ring of the Seven Curses. Examples: minecraft:iron_golem, minecraft:zombified_piglin. Changing this option required game restart to take effect.");
            Arrays.stream(blacklist).forEach(entry -> neutralAngerBlacklist.add(new ResourceLocation(entry)));
        }
        builder.popCategory();
        builder.popPrefix();
        builder.pushCategory(prevCategory);
    }

    public CursedRing() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing3");
            if (painMultiplier.getValue().asMultiplier() == 2.0) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing4");
            } else {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing4_alt", ChatFormatting.GOLD, painMultiplier + "%");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing6", ChatFormatting.GOLD, armorDebuff + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing7", ChatFormatting.GOLD, monsterDamageDebuff + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing12", ChatFormatting.GOLD, lootingBonus);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing13", ChatFormatting.GOLD, fortuneBonus);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing14", ChatFormatting.GOLD, experienceBonus + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing15", ChatFormatting.GOLD, enchantingBonus);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing16");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing17");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRing18");
        } else {
            if (enableLore.getValue()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore1");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore2");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore3");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore4");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore5");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore6");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.cursedRingLore7");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.canUnequipBoundRelics((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eternallyBound2");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ArrayListMultimap atrributeMap = ArrayListMultimap.create();
        atrributeMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("457d0ac3-69e4-482f-b636-22e0802da6bd"), "enigmaticlegacy:armor_modifier", (double)(-armorDebuff.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_TOTAL));
        atrributeMap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("95e70d83-3d50-4241-a835-996e1ef039bb"), "enigmaticlegacy:armor_toughness_modifier", (double)(-armorDebuff.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return atrributeMap;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    @Override
    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && SuperpositionHandler.canUnequipBoundRelics(player = (Player)livingEntity)) {
            return super.canUnequip(context, stack);
        }
        return false;
    }

    @Override
    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return false;
    }

    @Override
    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        SuperpositionHandler.setCurrentWorldCursed(false);
    }

    @Override
    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CursedRingEquippedTrigger.INSTANCE.trigger(player);
        }
        SuperpositionHandler.setCurrentWorldCursed(true);
    }

    @Override
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean isItemDeathPersistent(ItemStack stack) {
        return stack.m_41720_().equals(this) || stack.m_41720_().equals(EnigmaticItems.ENIGMATIC_AMULET);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        if (context.entity().m_9236_().f_46443_ || !(context.entity() instanceof Player)) {
            return;
        }
        Player player = (Player)context.entity();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, neutralAngerRange.getValue()));
        List endermen = player.m_9236_().m_45976_(EnderMan.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, endermenRandomportRange.getValue()));
        for (EnderMan enderman : endermen) {
            if (!(random.nextDouble() <= 0.002 * endermenRandomportFrequency.getValue()) || !enderman.m_32500_((Entity)player) || !player.m_142582_((Entity)enderman)) continue;
            enderman.m_6710_((LivingEntity)player);
        }
        for (LivingEntity checkedEntity : genericMobs) {
            IronGolem golem;
            TamableAnimal tamable;
            double visibility = player.m_20968_((Entity)checkedEntity);
            double angerDistance = Math.max(neutralAngerRange.getValue() * visibility, neutralXRayRange.getValue());
            if (checkedEntity.m_20275_(player.m_20185_(), player.m_20186_(), player.m_20189_()) > angerDistance * angerDistance) continue;
            if (checkedEntity instanceof Piglin && !SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticItems.AVARICE_SCROLL)) {
                Piglin piglin = (Piglin)checkedEntity;
                if (piglin.m_5448_() != null && piglin.m_5448_().m_6084_() || !player.m_142582_((Entity)checkedEntity) && !((double)player.m_20270_((Entity)checkedEntity) <= neutralXRayRange.getValue())) continue;
                PiglinAi.m_34837_((Piglin)piglin, (LivingEntity)player);
                continue;
            }
            if (!(checkedEntity instanceof NeutralMob)) continue;
            NeutralMob neutral = (NeutralMob)checkedEntity;
            if (neutralAngerBlacklist.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)checkedEntity.m_6095_())) || neutral instanceof TamableAnimal && (tamable = (TamableAnimal)neutral).m_21824_() || (!SuperpositionHandler.hasItem(player, EnigmaticItems.ANIMAL_GUIDEBOOK) ? neutral instanceof IronGolem && (golem = (IronGolem)neutral).m_28876_() || neutral instanceof Bee && (saveTheBees.getValue() || SuperpositionHandler.hasItem(player, EnigmaticItems.ANIMAL_GUIDEBOOK)) : EnigmaticItems.ANIMAL_GUIDEBOOK.isTamableAnimal(checkedEntity))) continue;
            if (neutral.m_5448_() != null && neutral.m_5448_().m_6084_() || !player.m_142582_((Entity)checkedEntity) && !((double)player.m_20270_((Entity)checkedEntity) <= neutralXRayRange.getValue())) continue;
            neutral.m_6710_((LivingEntity)player);
        }
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map list = EnchantmentHelper.m_44831_((ItemStack)book);
        if (list.containsKey(Enchantments.f_44963_)) {
            return false;
        }
        return super.isBookEnchantable(stack, book);
    }

    public double getAngerRange() {
        return neutralAngerRange.getValue();
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio) {
        return super.getFortuneLevel(slotContext, lootContext, curio) + fortuneBonus.getValue();
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack curio) {
        return super.getLootingLevel(slotContext, source, target, baseLooting, curio) + lootingBonus.getValue();
    }

    static {
        neutralAngerBlacklist = new ArrayList<ResourceLocation>();
    }
}

