/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.helpers;

import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerXpEvent;

public class ExperienceHelper {
    public static int getPlayerXP(Player player) {
        return (int)((float)ExperienceHelper.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int getPlayerXPLevel(Player player) {
        return player.f_36078_;
    }

    public static void drainPlayerXP(Player player, int amount) {
        ExperienceHelper.addPlayerXP(player, -amount);
    }

    public static void addPlayerXP(Player player, int amount) {
        PlayerXpEvent.XpChange eventXP = new PlayerXpEvent.XpChange(player, amount);
        amount = eventXP.getAmount();
        int oldLevel = ExperienceHelper.getPlayerXPLevel(player);
        int newLevel = ExperienceHelper.getLevelForExperience(ExperienceHelper.getPlayerXP(player) + amount);
        int experience = ExperienceHelper.getPlayerXP(player) + amount;
        if (oldLevel != newLevel) {
            PlayerXpEvent.LevelChange eventLvl = new PlayerXpEvent.LevelChange(player, newLevel - oldLevel);
            int remainder = experience - ExperienceHelper.getExperienceForLevel(newLevel);
            newLevel = oldLevel + eventLvl.getLevels();
            amount = ExperienceHelper.getExperienceForLevel(newLevel) - ExperienceHelper.getExperienceForLevel(oldLevel) + remainder;
        }
        player.f_36079_ = experience;
        player.f_36078_ = ExperienceHelper.getLevelForExperience(experience);
        int expForLevel = ExperienceHelper.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return level * level + 6 * level;
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelForExperience(int experience) {
        if (experience <= 0) {
            return 0;
        }
        int i = 0;
        while (ExperienceHelper.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }
}

