/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.api.items;

import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IMultiblockMiningTool {
    default public boolean areaEffectsEnabled(Player player, ItemStack stack) {
        return this.areaEffectsAllowed(stack) && (!player.m_6047_() || OmniconfigHandler.disableAOEShiftSuppression.getValue());
    }

    default public boolean areaEffectsAllowed(ItemStack stack) {
        if (stack.m_41720_() instanceof IMultiblockMiningTool) {
            return ItemNBTHelper.getBoolean(stack, "MultiblockEffectsEnabled", true);
        }
        return false;
    }

    default public void enableAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IMultiblockMiningTool) {
            ItemNBTHelper.setBoolean(stack, "MultiblockEffectsEnabled", true);
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        }
    }

    default public void disableAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IMultiblockMiningTool) {
            ItemNBTHelper.setBoolean(stack, "MultiblockEffectsEnabled", false);
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_OFF, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        }
    }

    default public void toggleAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IMultiblockMiningTool) {
            if (this.areaEffectsAllowed(stack)) {
                this.disableAreaEffects(player, stack);
            } else {
                this.enableAreaEffects(player, stack);
            }
        }
    }
}

