/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.client.FluidRenderHelper;
import dev.xkmc.cuisinedelight.content.logic.CookTransformConfig;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.CookTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.FluidTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.l2library.util.Proxy;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CuisineSkilletRenderer
implements BlockEntityRenderer<CuisineSkilletBlockEntity> {
    public static void renderItem(float time, CookingData data, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        int i = 1;
        float fly = time * (1.0f - time) * 4.0f;
        FluidRenderHelper helper = new FluidRenderHelper();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -0.453125f + fly * 16.0f / 32.0f, 0.0f);
        for (CookingData.CookingEntry entry : data.contents) {
            ItemStack food = entry.getItem();
            CookTransform handle = CookTransformConfig.get(food);
            if (handle instanceof FluidTransform) {
                FluidTransform fluid = (FluidTransform)handle;
                helper.addFluid(fluid);
                continue;
            }
            ItemStack render = handle.renderStack(entry.getStage(data), food);
            Random random = new Random(entry.seed());
            poseStack.m_252880_(0.0f, (fly * 4.0f + 1.0f) / 32.0f, 0.0f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            int itemLight = light;
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(food);
            assert (config != null);
            boolean overcooked = entry.getStage(data) == Stage.OVERCOOKED;
            boolean burnt = entry.getMaxStirTime(data) > (float)config.stir_time;
            itemLight = handle.lightAdjust(itemLight, overcooked, burnt);
            renderer.m_269128_(render, ItemDisplayContext.GROUND, itemLight, overlay, poseStack, buffer, (Level)Minecraft.m_91087_().f_91073_, i++);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        helper.render(poseStack, buffer, light);
    }

    public CuisineSkilletRenderer(BlockEntityRendererProvider.Context dispatcher) {
    }

    public void render(CuisineSkilletBlockEntity be, float pTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        CookingData data = be.cookingData;
        if (!data.contents.isEmpty()) {
            data.update(Proxy.getClientWorld().m_46467_());
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            float time = be.getStirPercent(pTick);
            CuisineSkilletRenderer.renderItem(time, data, poseStack, buffer, light, overlay);
            poseStack.m_85849_();
        }
    }
}

