/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.loot.modification.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.loot.modification.LootModifierSerializers;
import com.teamabnormals.blueprint.common.loot.modification.modifiers.LootModifier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public record LootPoolsModifier(List<LootPool> pools, boolean replace) implements LootModifier<LootPoolsModifier>
{
    public static final Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"f_79109_");

    @Override
    public void modify(LootTable table) {
        try {
            if (this.replace) {
                POOLS.set(table, this.pools);
            } else {
                ((List)POOLS.get(table)).addAll(this.pools);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Serializer getSerializer() {
        return LootModifierSerializers.POOLS;
    }

    public static final class Serializer
    implements LootModifier.Serializer<LootPoolsModifier> {
        @Override
        public JsonElement serialize(LootPoolsModifier modifier, Gson gson) throws JsonParseException {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("replace", Boolean.valueOf(modifier.replace));
            JsonArray pools = new JsonArray();
            for (LootPool pool : modifier.pools) {
                pools.add(gson.toJsonTree((Object)pool));
            }
            jsonObject.add("pools", (JsonElement)pools);
            return jsonObject;
        }

        @Override
        public LootPoolsModifier deserialize(JsonElement element, Pair<Gson, LootDataManager> additional) throws JsonParseException {
            JsonObject jsonObject = element.getAsJsonObject();
            ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
            JsonArray poolsArray = jsonObject.getAsJsonArray("pools");
            Gson gson = (Gson)additional.getFirst();
            poolsArray.forEach(entry -> lootPools.add((LootPool)gson.fromJson(entry, LootPool.class)));
            return new LootPoolsModifier(lootPools, jsonObject.get("replace").getAsBoolean());
        }
    }
}

