/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.enchantment;

import javax.annotation.ParametersAreNonnullByDefault;
import net.Pandarix.betterarcheology.BetterArcheologyConfig;
import net.Pandarix.betterarcheology.enchantment.ArtifactEnchantment;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PenetratingStrikeEnchantment
extends ArtifactEnchantment {
    public PenetratingStrikeEnchantment(Enchantment.Rarity weight, EquipmentSlot ... slotTypes) {
        super(weight, EnchantmentCategory.WEAPON, slotTypes);
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean m_6081_(ItemStack pStack) {
        if (BetterArcheologyConfig.penetratingStrikeEnabled.get().booleanValue() && BetterArcheologyConfig.artifactsEnabled.get().booleanValue()) {
            if (pStack.m_41720_() instanceof AxeItem || pStack.m_41720_() instanceof SwordItem) {
                return true;
            }
            return super.m_6081_(pStack);
        }
        return false;
    }

    public int m_6586_() {
        return 1;
    }

    @ParametersAreNonnullByDefault
    public void m_7677_(LivingEntity user, Entity target, int level) {
        if (!BetterArcheologyConfig.artifactsEnabled.get().booleanValue() || !BetterArcheologyConfig.penetratingStrikeEnabled.get().booleanValue()) {
            return;
        }
        if (target instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)target;
            if (user instanceof Player) {
                Player player = (Player)user;
                int enchantmentProtectionFactor = EnchantmentHelper.m_44856_((Iterable)target.m_6168_(), (DamageSource)player.m_269291_().m_269333_(targetEntity));
                double damagePercentageProtected = (float)enchantmentProtectionFactor / 25.0f;
                float damageInflicted = 0.0f;
                if (player.m_21205_().m_41720_() instanceof SwordItem) {
                    damageInflicted = ((SwordItem)player.m_21205_().m_41720_()).m_43299_() + 1.0f;
                } else if (player.m_21205_().m_41720_() instanceof AxeItem) {
                    damageInflicted = ((AxeItem)player.m_21205_().m_41720_()).m_41008_() + 1.0f;
                }
                float totalProtectedDamage = (float)((double)damageInflicted * damagePercentageProtected);
                float damageToRedo = (float)((double)totalProtectedDamage * BetterArcheologyConfig.penetratingStrikeIgnorance.get());
                if (level == 1) {
                    targetEntity.m_6469_(targetEntity.m_269291_().m_269425_(), damageToRedo * 7.5f);
                }
                if (!user.m_9236_().m_5776_()) {
                    user.m_9236_().m_247517_(null, target.m_20097_(), SoundEvents.f_11672_, SoundSource.BLOCKS);
                }
            }
        }
        super.m_7677_(user, target, level);
    }
}

