/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFFeatureModifiers;

public class TrunkSideDecorator
extends TreeDecorator {
    public static final Codec<TrunkSideDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)64).fieldOf("placement_count").forGetter(o -> o.count), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_of_placement").forGetter(o -> Float.valueOf(o.probability)), (App)BlockStateProvider.f_68747_.fieldOf("deco_provider").forGetter(o -> o.decoration)).apply((Applicative)instance, TrunkSideDecorator::new));
    private final int count;
    private final float probability;
    private final BlockStateProvider decoration;

    public TrunkSideDecorator(int count, float probability, BlockStateProvider decorator) {
        this.count = count;
        this.probability = probability;
        this.decoration = decorator;
    }

    protected TreeDecoratorType<TrunkSideDecorator> m_6663_() {
        return (TreeDecoratorType)TFFeatureModifiers.TRUNKSIDE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        int blockCount = context.m_226068_().size();
        if (blockCount == 0) {
            TwilightForestMod.LOGGER.error("[TrunkSideDecorator] Trunk Blocks were empty! Why?");
            return;
        }
        for (int attempt = 0; attempt < this.count; ++attempt) {
            Direction direction;
            BlockPos logPos;
            BlockPos newPos;
            if (context.m_226067_().m_188501_() >= this.probability || !context.m_226059_(newPos = (logPos = (BlockPos)context.m_226068_().get(context.m_226067_().m_188503_(blockCount))).m_7918_((direction = Direction.Plane.HORIZONTAL.m_235690_(context.m_226067_())).m_122429_(), 0, direction.m_122431_()))) continue;
            if (this.decoration.m_213972_(context.m_226067_(), newPos).m_61138_((Property)BlockStateProperties.f_61372_)) {
                context.m_226061_(newPos, (BlockState)this.decoration.m_213972_(context.m_226067_(), newPos).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction));
                continue;
            }
            context.m_226061_(newPos, this.decoration.m_213972_(context.m_226067_(), newPos));
        }
    }
}

