/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.TomeBolt;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;

public class DeathTome
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_LECTERN = SynchedEntityData.m_135353_(DeathTome.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;

    public DeathTome(EntityType<? extends DeathTome> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 100, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LECTERN, (Object)false);
    }

    public void setOnLectern(boolean hidden) {
        this.f_19804_.m_135381_(DATA_LECTERN, (Object)hidden);
    }

    public boolean isOnLectern() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LECTERN);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_21532_() {
        return super.m_21532_() || this.isOnLectern();
    }

    public void m_8107_() {
        if (this.isOnLectern()) {
            BlockState state = this.m_9236_().m_8055_(this.m_20183_());
            if (state.m_60734_() instanceof LecternBlock) {
                Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                this.f_19859_ = direction.m_122435_();
                this.m_146922_(this.f_19859_);
                this.f_20883_ = this.f_19859_;
                this.f_20884_ = this.f_19859_;
                this.f_20885_ = this.f_19859_;
                this.f_20886_ = this.f_19859_;
                if (!this.m_9236_().m_5776_()) {
                    this.f_21346_.m_25373_();
                }
                if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 20.0) {
                    this.setOnLectern(false);
                    this.f_21343_.m_24901_();
                    this.m_6504_(this.m_5448_(), 1.0f);
                }
                return;
            }
            this.setOnLectern(false);
        }
        super.m_8107_();
        Vec3 vel = this.m_20184_();
        if (!this.m_20096_() && vel.m_7098_() < 0.0) {
            this.m_20256_(vel.m_82542_(1.0, 0.6, 1.0));
        }
        for (int i = 0; i < 1; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.m_217043_().m_188500_() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.5, 0.0);
        }
    }

    public void m_8119_() {
        if (this.isOnLectern()) {
            this.f_21363_ = -1;
        }
        if (this.m_9236_().f_46443_) {
            float f1 = this.flipT;
            if (this.f_19796_.m_188503_(this.isOnLectern() ? 120 : 30) == 0) {
                do {
                    this.flipT += (float)(this.f_19796_.m_188503_(4) - this.f_19796_.m_188503_(4));
                } while (f1 == this.flipT);
            }
            this.oFlip = this.flip;
            float f = (this.flipT - this.flip) * 0.4f;
            f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
            this.flipA += (f - this.flipA) * 0.9f;
            this.flip += this.flipA;
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource src, float damage) {
        if (this.isOnLectern()) {
            this.f_21343_.m_24901_();
            this.setOnLectern(false);
        }
        if (src.m_269533_(DamageTypeTags.f_268745_)) {
            damage *= 2.0f;
        }
        if (super.m_6469_(src, damage)) {
            if (damage > 0.0f && !this.m_9236_().m_5776_()) {
                LootParams ctx = TFLootTables.createLootParams((LivingEntity)this, true, src).m_287235_(LootContextParamSets.f_81415_);
                Objects.requireNonNull(this.m_9236_().m_7654_()).m_278653_().m_278676_(TFLootTables.DEATH_TOME_HURT).m_287228_(ctx, s -> this.m_5552_((ItemStack)s, 1.0f));
            }
            return true;
        }
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.DEATH_TOME_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.DEATH_TOME_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.DEATH_TOME_DEATH.get();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        TomeBolt projectile = new TomeBolt((EntityType<? extends TomeBolt>)((EntityType)TFEntities.TOME_BOLT.get()), this.m_9236_(), (LivingEntity)this);
        double tx = target.m_20185_() - this.m_20185_();
        double ty = target.m_20186_() + (double)target.m_20192_() - 1.1 - projectile.m_20186_();
        double tz = target.m_20189_() - this.m_20189_();
        float heightOffset = Mth.m_14116_((float)((float)(tx * tx + tz * tz))) * 0.2f;
        projectile.m_6686_(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.m_146850_(GameEvent.f_157778_);
        this.m_9236_().m_7967_((Entity)projectile);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_LECTERN, (Object)tag.m_128471_("on_lectern"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("on_lectern", ((Boolean)this.f_19804_.m_135370_(DATA_LECTERN)).booleanValue());
    }
}

