/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.PhantomAttackStartGoal;
import twilightforest.entity.ai.goal.PhantomThrowWeaponGoal;
import twilightforest.entity.ai.goal.PhantomUpdateFormationAndMoveGoal;
import twilightforest.entity.ai.goal.PhantomWatchAndAttackGoal;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class KnightPhantom
extends FlyingMob
implements Enemy,
EnforcedHomePoint {
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(KnightPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private static final EntityDataAccessor<Boolean> FLAG_CHARGING = SynchedEntityData.m_135353_(KnightPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier CHARGING_MODIFIER = new AttributeModifier("Charging attack boost", 7.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier NON_CHARGING_ARMOR_MODIFIER = new AttributeModifier("Inactive Armor boost", 4.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private int number;
    private int totalKnownKnights = 1;
    private int ticksProgress;
    private Formation currentFormation;
    private BlockPos chargePos = BlockPos.f_121853_;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();
    private final EntityDimensions invisibleSize = EntityDimensions.m_20398_((float)1.25f, (float)2.5f);
    private final EntityDimensions visibleSize = EntityDimensions.m_20398_((float)1.75f, (float)4.0f);

    public KnightPhantom(EntityType<? extends KnightPhantom> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.currentFormation = Formation.HOVER;
        this.f_21364_ = 93;
        this.f_21342_ = new NoClipMoveControl((Mob)this);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.getNumber() == 0) {
            this.bossInfo.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(accessor, difficulty, reason, spawnDataIn, dataTag);
        this.m_213945_(accessor.m_213780_(), difficulty);
        this.m_213946_(accessor.m_213780_(), difficulty);
        this.m_21051_(Attributes.f_22284_).m_22118_(NON_CHARGING_ARMOR_MODIFIER);
        return data;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TFItems.PHANTOM_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TFItems.PHANTOM_HELMET.get()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FLAG_CHARGING, (Object)false);
        this.m_20088_().m_135372_(HOME_POINT, Optional.empty());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PhantomWatchAndAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PhantomUpdateFormationAndMoveGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new PhantomAttackStartGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PhantomThrowWeaponGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public Formation getCurrentFormation() {
        return this.currentFormation;
    }

    public BlockPos getChargePos() {
        return this.chargePos;
    }

    public void setChargePos(BlockPos pos) {
        this.chargePos = pos;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public boolean m_6673_(DamageSource src) {
        return src.m_276093_(DamageTypes.f_268612_) || super.m_6673_(src);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.getRestrictionPoint() != null && this.getNumber() == 0) {
                this.m_9236_().m_46597_(this.getRestrictionPoint().m_122646_(), ((Block)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.getNumber() == 0) {
            float health = 0.0f;
            float maxHealth = 0.0f;
            int amount = 0;
            for (KnightPhantom nearbyKnight : this.getNearbyKnights()) {
                health += nearbyKnight.m_21223_();
                maxHealth += nearbyKnight.m_21233_();
                ++amount;
            }
            int remaining = this.totalKnownKnights - amount;
            if (remaining > 0) {
                maxHealth += this.m_21233_() * (float)remaining;
            }
            this.bossInfo.m_142711_(health / maxHealth);
        }
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                Item particleID = this.m_217043_().m_188499_() ? (Item)TFItems.PHANTOM_HELMET.get() : (Item)TFItems.KNIGHTMETAL_SWORD.get();
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)particleID)), this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + (double)this.m_217043_().m_188501_() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), 0.0, -0.1, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + (double)this.m_217043_().m_188501_() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + ((double)this.m_217043_().m_188501_() - 0.5) * (double)this.m_20205_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.m_217043_().m_188583_() * 0.02;
            double d1 = this.m_217043_().m_188583_() * 0.02;
            double d2 = this.m_217043_().m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<KnightPhantom> knights = this.getNearbyKnights();
            if (!knights.isEmpty()) {
                knights.forEach(KnightPhantom::updateMyNumber);
            } else if (!cause.m_269533_(DamageTypeTags.f_268738_)) {
                this.bossInfo.m_142711_(0.0f);
                BlockPos treasurePos = this.getRestrictionPoint() != null ? (serverLevel.m_8055_(this.getRestrictionPoint().m_122646_().m_7495_()).m_247087_() ? this.getRestrictionPoint().m_122646_().m_7495_() : this.getRestrictionPoint().m_122646_()) : this.m_20183_();
                TFLootTables.STRONGHOLD_BOSS.generateChest((WorldGenLevel)serverLevel, treasurePos, Direction.NORTH, false);
                Entity entity = cause.m_7639_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    TFAdvancements.KILL_ALL_PHANTOMS.trigger(player);
                }
                LandmarkUtil.markStructureConquered(this.m_9236_(), this, TFStructures.KNIGHT_STRONGHOLD, true);
                for (ServerPlayer player : this.hurtBy) {
                    TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
                }
                for (ServerPlayer player : this.m_9236_().m_45976_(ServerPlayer.class, new AABB(treasurePos).m_82400_(64.0))) {
                    TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity;
        if (this.m_21275_(source)) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
        }
        if ((entity = source.m_7639_()) instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return super.m_6469_(source, amount);
    }

    public void m_20093_() {
        if (!this.m_5825_()) {
            this.m_20254_(5);
            if (this.m_6469_(this.m_269291_().m_269233_(), 4.0f)) {
                this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
                EntityUtil.killLavaAround((Entity)this);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, TFDamageTypes.getEntityDamageSource(this.m_9236_(), TFDamageTypes.HAUNT, (Entity)this, new EntityType[0]));
    }

    public boolean m_6094_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_147240_(double damage, double xRatio, double zRatio) {
        this.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(xRatio * xRatio + zRatio * zRatio)));
        float distance = 0.2f;
        this.m_20256_(new Vec3(this.m_20184_().m_7096_() / 2.0, this.m_20184_().m_7098_() / 2.0, this.m_20184_().m_7094_() / 2.0));
        this.m_20256_(new Vec3(this.m_20184_().m_7096_() - xRatio / (double)f * (double)distance, this.m_20184_().m_7098_() + (double)distance, this.m_20184_().m_7094_() - zRatio / (double)f * (double)distance));
        if (this.m_20184_().m_7098_() > 0.4) {
            this.m_20334_(this.m_20184_().m_7096_(), 0.4, this.m_20184_().m_7094_());
        }
    }

    public List<KnightPhantom> getNearbyKnights() {
        return this.m_9236_().m_6443_(KnightPhantom.class, this.m_20191_().m_82400_(64.0), LivingEntity::m_6084_);
    }

    private void updateMyNumber() {
        ArrayList nums = Lists.newArrayList();
        List<KnightPhantom> knights = this.getNearbyKnights();
        for (KnightPhantom knight : knights) {
            if (knight == this || !knight.m_6084_()) continue;
            nums.add(knight.getNumber());
            if (knight.getNumber() != 0) continue;
            this.setRestrictionPoint(knight.getRestrictionPoint());
        }
        if (nums.isEmpty()) {
            this.setNumber(0);
            return;
        }
        int[] n = Ints.toArray((Collection)nums);
        Arrays.sort(n);
        int smallest = n[0];
        int largest = knights.size() + 1;
        int smallestUnused = largest + 1;
        if (smallest > 0) {
            smallestUnused = 0;
        } else {
            for (int i = 1; i < largest; ++i) {
                if (Arrays.binarySearch(n, i) >= 0) continue;
                smallestUnused = i;
                break;
            }
        }
        if (this.totalKnownKnights < largest) {
            this.totalKnownKnights = largest;
        }
        if (this.number > smallestUnused || nums.contains(this.number)) {
            this.setNumber(smallestUnused);
        }
    }

    public boolean isChargingAtPlayer() {
        return (Boolean)this.m_20088_().m_135370_(FLAG_CHARGING);
    }

    private void setChargingAtPlayer(boolean flag) {
        this.m_20088_().m_135381_(FLAG_CHARGING, (Object)flag);
        if (!this.m_9236_().m_5776_()) {
            if (flag) {
                if (!this.m_21051_(Attributes.f_22281_).m_22109_(CHARGING_MODIFIER)) {
                    this.m_21051_(Attributes.f_22281_).m_22118_(CHARGING_MODIFIER);
                }
                if (this.m_21051_(Attributes.f_22284_).m_22109_(NON_CHARGING_ARMOR_MODIFIER)) {
                    this.m_21051_(Attributes.f_22284_).m_22130_(NON_CHARGING_ARMOR_MODIFIER);
                }
            } else {
                this.m_21051_(Attributes.f_22281_).m_22130_(CHARGING_MODIFIER);
                if (!this.m_21051_(Attributes.f_22284_).m_22109_(NON_CHARGING_ARMOR_MODIFIER)) {
                    this.m_21051_(Attributes.f_22284_).m_22118_(NON_CHARGING_ARMOR_MODIFIER);
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (FLAG_CHARGING.equals(accessor)) {
            this.m_6210_();
        }
        super.m_7350_(accessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isChargingAtPlayer() ? this.visibleSize : this.invisibleSize;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.KNIGHT_PHANTOM_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.KNIGHT_PHANTOM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.KNIGHT_PHANTOM_DEATH.get();
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.updateMyNumber();
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    private int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        return this.currentFormation.duration;
    }

    public boolean isSwordKnight() {
        return this.m_21205_().m_150930_((Item)TFItems.KNIGHTMETAL_SWORD.get());
    }

    public boolean isAxeKnight() {
        return this.m_21205_().m_150930_((Item)TFItems.KNIGHTMETAL_AXE.get());
    }

    public boolean isPickKnight() {
        return this.m_21205_().m_150930_((Item)TFItems.KNIGHTMETAL_PICKAXE.get());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        if (number == 0) {
            this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(64.0)).forEach(this::m_6457_);
        }
        switch (number % 3) {
            case 0: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get()));
                break;
            }
            case 1: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_AXE.get()));
                break;
            }
            case 2: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_PICKAXE.get()));
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.saveHomePointToNbt(compound);
        compound.m_128405_("MyNumber", this.getNumber());
        compound.m_128405_("Formation", this.getFormationAsNumber());
        compound.m_128405_("TicksProgress", this.getTicksProgress());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound);
        this.setNumber(compound.m_128451_("MyNumber"));
        this.switchToFormationByNumber(compound.m_128451_("Formation"));
        this.setTicksProgress(compound.m_128451_("TicksProgress"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
        if (pos != null) {
            this.chargePos = pos.m_122646_();
        }
    }

    @Override
    public int getHomeRadius() {
        return 30;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    public static enum Formation {
        HOVER(90),
        LARGE_CLOCKWISE(180),
        SMALL_CLOCKWISE(90),
        LARGE_ANTICLOCKWISE(180),
        SMALL_ANTICLOCKWISE(90),
        CHARGE_PLUSX(180),
        CHARGE_MINUSX(180),
        CHARGE_PLUSZ(180),
        CHARGE_MINUSZ(180),
        WAITING_FOR_LEADER(10),
        ATTACK_PLAYER_START(50),
        ATTACK_PLAYER_ATTACK(50);

        final int duration;

        private Formation(int duration) {
            this.duration = duration;
        }
    }
}

