/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.forcefield;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.block.forcefield.ForceFieldModel;
import twilightforest.client.model.block.forcefield.ForceFieldModelBuilder;

public class ForceFieldModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    protected final List<ForceFieldElementBuilder> elements = new ArrayList<ForceFieldElementBuilder>();

    public static <T extends ModelBuilder<T>> ForceFieldModelBuilder<T> begin(T parent, ExistingFileHelper helper) {
        return new ForceFieldModelBuilder<T>(parent, helper);
    }

    private ForceFieldModelBuilder<T> self() {
        return this;
    }

    protected ForceFieldModelBuilder(T parent, ExistingFileHelper helper) {
        super(TwilightForestMod.prefix("force_field"), parent, helper);
    }

    public ForceFieldElementBuilder forceFieldElement() {
        ForceFieldElementBuilder ret = new ForceFieldElementBuilder();
        this.elements.add(ret);
        return ret;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.forEach(forceFieldElementBuilder -> {
                BlockElement part = forceFieldElementBuilder.build();
                JsonObject partObj = new JsonObject();
                if (forceFieldElementBuilder.condition != null) {
                    JsonObject condition = new JsonObject();
                    condition.addProperty("if", (Boolean)forceFieldElementBuilder.condition.getSecond());
                    condition.addProperty("direction", ((ForceFieldModel.ExtraDirection)((Object)((Object)forceFieldElementBuilder.condition.getFirst()))).m_7912_());
                    JsonArray parents = new JsonArray();
                    for (ForceFieldModel.ExtraDirection parent : forceFieldElementBuilder.parents) {
                        parents.add(parent.m_7912_());
                    }
                    condition.add("parents", (JsonElement)parents);
                    partObj.add("condition", (JsonElement)condition);
                }
                partObj.add("from", (JsonElement)this.serializeVector3f(part.f_111308_));
                partObj.add("to", (JsonElement)this.serializeVector3f(part.f_111309_));
                if (part.f_111311_ != null) {
                    JsonObject rotation = new JsonObject();
                    rotation.add("origin", (JsonElement)this.serializeVector3f(part.f_111311_.f_111378_()));
                    rotation.addProperty("axis", part.f_111311_.f_111379_().m_7912_());
                    rotation.addProperty("angle", (Number)Float.valueOf(part.f_111311_.f_111380_()));
                    if (part.f_111311_.f_111381_()) {
                        rotation.addProperty("rescale", Boolean.valueOf(part.f_111311_.f_111381_()));
                    }
                    partObj.add("rotation", (JsonElement)rotation);
                }
                if (!part.f_111312_) {
                    partObj.addProperty("shade", Boolean.valueOf(part.f_111312_));
                }
                JsonObject faces = new JsonObject();
                for (Direction dir : Direction.values()) {
                    BlockElementFace face = (BlockElementFace)part.f_111310_.get(dir);
                    if (face == null) continue;
                    JsonObject faceObj = new JsonObject();
                    faceObj.addProperty("texture", this.serializeLocOrKey(face.f_111356_));
                    if (!Arrays.equals(face.f_111357_.f_111387_, part.m_111320_(dir))) {
                        faceObj.add("uv", new Gson().toJsonTree((Object)face.f_111357_.f_111387_));
                    }
                    if (face.f_111354_ != null) {
                        faceObj.addProperty("cullface", face.f_111354_.m_7912_());
                    }
                    if (face.f_111357_.f_111388_ != 0) {
                        faceObj.addProperty("rotation", (Number)face.f_111357_.f_111388_);
                    }
                    if (face.f_111355_ != -1) {
                        faceObj.addProperty("tintindex", (Number)face.f_111355_);
                    }
                    if (!face.getFaceData().equals((Object)ForgeFaceData.DEFAULT)) {
                        faceObj.add("forge_data", (JsonElement)ForgeFaceData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)face.getFaceData()).result().get());
                    }
                    faces.add(dir.m_7912_(), (JsonElement)faceObj);
                }
                if (!part.f_111310_.isEmpty()) {
                    partObj.add("faces", (JsonElement)faces);
                }
                elements.add((JsonElement)partObj);
            });
            json.add("elements", (JsonElement)elements);
        }
        return json;
    }

    private String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return new ResourceLocation(tex).toString();
    }

    private JsonArray serializeVector3f(Vector3f vec) {
        JsonArray ret = new JsonArray();
        ret.add(this.serializeFloat(vec.x()));
        ret.add(this.serializeFloat(vec.y()));
        ret.add(this.serializeFloat(vec.z()));
        return ret;
    }

    private Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }

    public class ForceFieldElementBuilder {
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private final Map<Direction, twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder> faces = new LinkedHashMap<Direction, twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder>();
        private twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder rotation;
        private boolean shade = true;
        private int color = -1;
        private int blockLight = 0;
        private int skyLight = 0;
        private boolean hasAmbientOcclusion = true;
        private Pair<ForceFieldModel.ExtraDirection, Boolean> condition = null;
        private final List<ForceFieldModel.ExtraDirection> parents = new ArrayList<ForceFieldModel.ExtraDirection>();

        private void validateCoordinate(float coord, char name) {
            Preconditions.checkArgument((!(coord < -16.0f) && !(coord > 32.0f) ? 1 : 0) != 0, (String)("Position " + name + " out of range, must be within [-16, 32]. Found: %d"), (Object)Float.valueOf(coord));
        }

        private void validatePosition(Vector3f pos) {
            this.validateCoordinate(pos.x(), 'x');
            this.validateCoordinate(pos.y(), 'y');
            this.validateCoordinate(pos.z(), 'z');
        }

        public ForceFieldElementBuilder from(float x, float y, float z) {
            this.from = new Vector3f(x, y, z);
            this.validatePosition(this.from);
            return this;
        }

        public ForceFieldElementBuilder to(float x, float y, float z) {
            this.to = new Vector3f(x, y, z);
            this.validatePosition(this.to);
            return this;
        }

        public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder face(Direction dir) {
            Preconditions.checkNotNull((Object)dir, (Object)"Direction must not be null");
            return this.faces.computeIfAbsent(dir, x$0 -> new FaceBuilder((Direction)x$0));
        }

        public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder rotation() {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            return this.rotation;
        }

        public ForceFieldElementBuilder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public ForceFieldElementBuilder allFaces(BiConsumer<Direction, twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder> action) {
            Arrays.stream(Direction.values()).forEach(d -> action.accept((Direction)d, (twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder)this.face((Direction)d)));
            return this;
        }

        public ForceFieldElementBuilder faces(BiConsumer<Direction, twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder> action) {
            this.faces.forEach(action);
            return this;
        }

        public ForceFieldElementBuilder textureAll(String texture) {
            return this.allFaces(this.addTexture(texture));
        }

        public ForceFieldElementBuilder texture(String texture) {
            return this.faces(this.addTexture(texture));
        }

        public ForceFieldElementBuilder cube(String texture) {
            return this.allFaces(this.addTexture(texture).andThen((dir, f) -> f.cullface(dir)));
        }

        public ForceFieldElementBuilder emissivity(int blockLight, int skyLight) {
            this.blockLight = blockLight;
            this.skyLight = skyLight;
            return this;
        }

        public ForceFieldElementBuilder color(int color) {
            this.color = color;
            return this;
        }

        public ForceFieldElementBuilder ao(boolean ao) {
            this.hasAmbientOcclusion = ao;
            return this;
        }

        public ForceFieldElementBuilder ifState(ForceFieldModel.ExtraDirection condition, boolean b) {
            this.condition = Pair.of((Object)((Object)condition), (Object)b);
            return this;
        }

        public ForceFieldElementBuilder ifSame() {
            ForceFieldElementBuilder newBuilder = this.end().forceFieldElement();
            newBuilder.condition = Pair.of((Object)((Object)((ForceFieldModel.ExtraDirection)((Object)this.condition.getFirst()))), (Object)((Boolean)this.condition.getSecond()));
            return newBuilder;
        }

        public ForceFieldElementBuilder ifElse() {
            ForceFieldElementBuilder newBuilder = this.end().forceFieldElement();
            newBuilder.condition = Pair.of((Object)((Object)((ForceFieldModel.ExtraDirection)((Object)this.condition.getFirst()))), (Object)((Boolean)this.condition.getSecond() == false ? 1 : 0));
            return newBuilder;
        }

        public ForceFieldElementBuilder parents(ForceFieldModel.ExtraDirection ... parents) {
            Collections.addAll(this.parents, parents);
            return this;
        }

        private BiConsumer<Direction, twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder> addTexture(String texture) {
            return ($, f) -> f.texture(texture);
        }

        BlockElement build() {
            Map faces = this.faces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FaceBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
            return new BlockElement(this.from, this.to, faces, this.rotation == null ? null : this.rotation.build(), this.shade, new ForgeFaceData(this.color, this.blockLight, this.skyLight, this.hasAmbientOcclusion));
        }

        public ForceFieldModelBuilder<T> end() {
            return ForceFieldModelBuilder.this.self();
        }

        public class FaceBuilder {
            private Direction cullface;
            private int tintindex = -1;
            private String texture = MissingTextureAtlasSprite.m_118071_().toString();
            private float[] uvs;
            private FaceRotation rotation = FaceRotation.ZERO;
            private int color = -1;
            private int blockLight = 0;
            private int skyLight = 0;
            private boolean hasAmbientOcclusion = true;

            FaceBuilder(Direction dir) {
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder cullface(@Nullable Direction dir) {
                this.cullface = dir;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder tintindex(int index) {
                this.tintindex = index;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder texture(String texture) {
                Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
                this.texture = texture;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder uvs(float u1, float v1, float u2, float v2) {
                this.uvs = new float[]{u1, v1, u2, v2};
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder rotation(FaceRotation rot) {
                Preconditions.checkNotNull((Object)((Object)rot), (Object)"Rotation must not be null");
                this.rotation = rot;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder emissivity(int blockLight, int skyLight) {
                this.blockLight = blockLight;
                this.skyLight = skyLight;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder color(int color) {
                this.color = color;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.FaceBuilder ao(boolean ao) {
                this.hasAmbientOcclusion = ao;
                return this;
            }

            BlockElementFace build() {
                if (this.texture == null) {
                    throw new IllegalStateException("A model face must have a texture");
                }
                return new BlockElementFace(this.cullface, this.tintindex, this.texture, new BlockFaceUV(this.uvs, this.rotation.rotation), new ForgeFaceData(this.color, this.blockLight, this.skyLight, this.hasAmbientOcclusion));
            }

            public ForceFieldElementBuilder end() {
                return ForceFieldElementBuilder.this;
            }
        }

        public class RotationBuilder {
            private Vector3f origin;
            private Direction.Axis axis;
            private float angle;
            private boolean rescale;

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder origin(float x, float y, float z) {
                this.origin = new Vector3f(x, y, z);
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder axis(Direction.Axis axis) {
                Preconditions.checkNotNull((Object)axis, (Object)"Axis must not be null");
                this.axis = axis;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder angle(float angle) {
                Preconditions.checkArgument((angle == 0.0f || Mth.m_14154_((float)angle) == 22.5f || Mth.m_14154_((float)angle) == 45.0f ? 1 : 0) != 0, (String)"Invalid rotation %f found, only -45/-22.5/0/22.5/45 allowed", (Object)Float.valueOf(angle));
                this.angle = angle;
                return this;
            }

            public twilightforest.client.model.block.forcefield.ForceFieldModelBuilder$ForceFieldElementBuilder.RotationBuilder rescale(boolean rescale) {
                this.rescale = rescale;
                return this;
            }

            BlockElementRotation build() {
                return new BlockElementRotation(this.origin, this.axis, this.angle, this.rescale);
            }

            public ForceFieldElementBuilder end() {
                return ForceFieldElementBuilder.this;
            }
        }
    }

    public static enum FaceRotation {
        ZERO(0),
        CLOCKWISE_90(90),
        UPSIDE_DOWN(180),
        COUNTERCLOCKWISE_90(270);

        final int rotation;

        private FaceRotation(int rotation) {
            this.rotation = rotation;
        }
    }
}

