/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFParticleType;

public class FireflyBlockEntity
extends BlockEntity {
    private int yawDelay;
    public int currentYaw;
    private int desiredYaw;
    public float glowIntensity;
    private boolean glowing;
    private int glowDelay;
    public final float randRot = (float)RandomSource.m_216327_().m_188503_(4) * 90.0f;

    public FireflyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.FIREFLY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FireflyBlockEntity te) {
        if (level.m_5776_()) {
            if (te.anyPlayerInRange() && level.m_213780_().m_188503_(20) == 0) {
                te.spawnParticles();
            }
            if (te.yawDelay > 0) {
                --te.yawDelay;
            } else {
                if (te.currentYaw == 0 && te.desiredYaw == 0) {
                    te.yawDelay = 200 + level.m_213780_().m_188503_(200);
                    te.desiredYaw = level.m_213780_().m_188503_(15) - level.m_213780_().m_188503_(15);
                }
                if (te.currentYaw < te.desiredYaw) {
                    ++te.currentYaw;
                }
                if (te.currentYaw > te.desiredYaw) {
                    --te.currentYaw;
                }
                if (te.currentYaw == te.desiredYaw) {
                    te.desiredYaw = 0;
                }
            }
            if (te.glowDelay > 0) {
                --te.glowDelay;
            } else {
                if (te.glowing && (double)te.glowIntensity >= 1.0) {
                    te.glowing = false;
                }
                if (te.glowing && (double)te.glowIntensity < 1.0) {
                    te.glowIntensity = (float)((double)te.glowIntensity + 0.05);
                }
                if (!te.glowing && te.glowIntensity > 0.0f) {
                    te.glowIntensity = (float)((double)te.glowIntensity - 0.05);
                }
                if (!te.glowing && te.glowIntensity <= 0.0f) {
                    te.glowing = true;
                    te.glowDelay = level.m_213780_().m_188503_(50);
                }
            }
        }
    }

    private boolean anyPlayerInRange() {
        return this.m_58904_().m_45924_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 16.0, false) != null;
    }

    private void spawnParticles() {
        double rx = (float)this.m_58899_().m_123341_() + this.m_58904_().m_213780_().m_188501_();
        double ry = (float)this.m_58899_().m_123342_() + this.m_58904_().m_213780_().m_188501_();
        double rz = (float)this.m_58899_().m_123343_() + this.m_58904_().m_213780_().m_188501_();
        this.m_58904_().m_7106_((ParticleOptions)TFParticleType.FIREFLY.get(), rx, ry, rz, 0.0, 0.0, 0.0);
    }
}

