/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import mekanism.api.security.ISecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.util.WorldUtils;
import mekanism.common.world.GenHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private Map<ResourceLocation, Object2IntMap<ChunkPos>> chunkVersions;
    private Map<ResourceLocation, Queue<ChunkPos>> chunkRegenMap;
    public static boolean flushTagAndRecipeCaches;
    public static boolean monitoringCardboardBox;
    @Nullable
    public static Predicate<ItemStack> fallbackItemCollector;

    public void addRegenChunk(ResourceKey<Level> dimension, ChunkPos chunkCoord) {
        ResourceLocation dimensionName;
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new Object2ObjectArrayMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionName = dimension.m_135782_())) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionName, list);
        } else {
            Queue<ChunkPos> regenPositions = this.chunkRegenMap.get(dimensionName);
            if (!regenPositions.contains(chunkCoord)) {
                regenPositions.add(chunkCoord);
            }
        }
    }

    public void resetChunkData() {
        this.chunkRegenMap = null;
        this.chunkVersions = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        ItemEntity entity;
        Entity entity2;
        if (monitoringCardboardBox) {
            Entity entity3 = event.getEntity();
            if (entity3 instanceof ItemEntity || entity3 instanceof ExperienceOrb) {
                entity3.m_146870_();
                event.setCanceled(true);
            }
        } else if (fallbackItemCollector != null && (entity2 = event.getEntity()) instanceof ItemEntity && fallbackItemCollector.test((entity = (ItemEntity)entity2).m_32055_())) {
            entity.m_146870_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        if (state != null && !state.m_60795_() && state.m_155947_()) {
            BlockEntity blockEntity = WorldUtils.getTileEntity((BlockGetter)event.getLevel(), event.getPos());
            if (!ISecurityUtils.INSTANCE.canAccess(event.getPlayer(), (ICapabilityProvider)blockEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public synchronized void chunkSave(ChunkDataEvent.Save event) {
        LevelAccessor world = event.getLevel();
        if (!world.m_5776_() && world instanceof Level) {
            Level level = (Level)world;
            int chunkVersion = MekanismConfig.world.userGenVersion.get();
            if (this.chunkVersions != null) {
                chunkVersion = this.chunkVersions.getOrDefault(level.m_46472_().m_135782_(), (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap()).getOrDefault((Object)event.getChunk().m_7697_(), chunkVersion);
            }
            event.getData().m_128405_("mekWorldGenVersion", chunkVersion);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        int version;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_() && (version = event.getData().m_128451_("mekWorldGenVersion")) < MekanismConfig.world.userGenVersion.get()) {
            if (this.chunkVersions == null) {
                this.chunkVersions = new Object2ObjectArrayMap();
            }
            ChunkPos chunkCoord = event.getChunk().m_7697_();
            ResourceKey dimension = level.m_46472_();
            this.chunkVersions.computeIfAbsent(dimension.m_135782_(), dim -> new Object2IntOpenHashMap()).put((Object)chunkCoord, version);
            if (MekanismConfig.world.enableRegeneration.get()) {
                this.addRegenChunk((ResourceKey<Level>)dimension, chunkCoord);
            }
        }
    }

    @SubscribeEvent
    public void chunkUnloadEvent(ChunkEvent.Unload event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_() && this.chunkVersions != null) {
            this.chunkVersions.getOrDefault(level.m_46472_().m_135782_(), (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap()).removeInt((Object)event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.m_5776_() && world instanceof Level) {
            Level level = (Level)world;
            if (this.chunkVersions != null) {
                this.chunkVersions.remove(level.m_46472_().m_135782_());
            }
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            FrequencyManager.load();
            MultiblockManager.createOrLoadAll();
            QIOGlobalItemLookup.INSTANCE.createOrLoad();
            RadiationManager.get().createOrLoad();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.serverTick();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.tickEnd((ServerLevel)event.level);
        }
    }

    private void serverTick() {
        FrequencyManager.tick();
        RadiationManager.get().tickServer();
    }

    private void tickEnd(ServerLevel world) {
        if (!world.f_46443_) {
            RadiationManager.get().tickServerWorld((Level)world);
            if (flushTagAndRecipeCaches) {
                for (ServerPlayer player : world.m_6907_()) {
                    AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                    if (!(abstractContainerMenu instanceof PortableQIODashboardContainer)) continue;
                    PortableQIODashboardContainer qioDashboard = (PortableQIODashboardContainer)abstractContainerMenu;
                    for (int index = 0; index < 3; index = (int)((byte)(index + 1))) {
                        qioDashboard.getCraftingWindow(index).invalidateRecipe();
                    }
                }
                flushTagAndRecipeCaches = false;
            }
            if (this.chunkRegenMap == null || !MekanismConfig.world.enableRegeneration.get()) {
                return;
            }
            ResourceLocation dimensionName = world.m_46472_().m_135782_();
            if (this.chunkRegenMap.containsKey(dimensionName)) {
                ChunkPos nextChunk;
                Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionName);
                Object2IntMap<ChunkPos> dimensionChunkVersions = this.chunkVersions == null ? Object2IntMaps.emptyMap() : this.chunkVersions.getOrDefault(dimensionName, (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap());
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    if (!WorldUtils.isChunkLoaded((LevelReader)world, nextChunk)) continue;
                    if (GenHandler.generate(world, nextChunk)) {
                        Mekanism.logger.info("Regenerating ores and salt at chunk {}", (Object)nextChunk);
                    }
                    if (this.chunkVersions == null) continue;
                    dimensionChunkVersions.removeInt((Object)nextChunk);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionName);
                }
            }
        }
    }
}

