/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.security;

import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ISecurityUtils {
    public static final ISecurityUtils INSTANCE = ServiceLoader.load(ISecurityUtils.class).findFirst().orElseThrow(() -> new IllegalStateException("No valid ServiceImpl for ISecurityUtils found"));

    @Contract(value="_, null -> true")
    public boolean canAccess(Player var1, @Nullable ICapabilityProvider var2);

    public boolean canAccessObject(Player var1, ISecurityObject var2);

    @Contract(value="_, null, _ -> true")
    public boolean canAccess(@Nullable UUID var1, @Nullable ICapabilityProvider var2, boolean var3);

    public boolean canAccessObject(@Nullable UUID var1, ISecurityObject var2, boolean var3);

    public boolean moreRestrictive(SecurityMode var1, SecurityMode var2);

    @Nullable
    public UUID getOwnerUUID(ICapabilityProvider var1);

    public SecurityMode getSecurityMode(@Nullable ICapabilityProvider var1, boolean var2);

    public SecurityMode getEffectiveSecurityMode(ISecurityObject var1, boolean var2);

    @Contract(value="_, null -> true")
    default public boolean canAccessOrDisplayError(Player player, @Nullable ICapabilityProvider provider) {
        if (this.canAccess(player, provider)) {
            return true;
        }
        if (!player.m_9236_().f_46443_) {
            this.displayNoAccess(player);
        }
        return false;
    }

    public void displayNoAccess(Player var1);

    public void addSecurityTooltip(ItemStack var1, List<Component> var2);
}

