/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.data;

import net.minecraft.data.PackOutput;
import slimeknights.mantle.fluid.texture.AbstractFluidTextureProvider;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;

public class FluidTextureProvider
extends AbstractFluidTextureProvider {
    public FluidTextureProvider(PackOutput packOutput) {
        super(packOutput, "tconstruct");
    }

    public void addTextures() {
        this.root(TinkerFluids.powderedSnow);
        this.root(TinkerFluids.potion).color(-524040);
        this.slime((FluidObject<?>)TinkerFluids.earthSlime, "earth");
        this.slime((FluidObject<?>)TinkerFluids.skySlime, "sky");
        this.slime((FluidObject<?>)TinkerFluids.enderSlime, "ender");
        this.slime((FluidObject<?>)TinkerFluids.magma);
        this.slime((FluidObject<?>)TinkerFluids.venom);
        this.slime((FluidObject<?>)TinkerFluids.liquidSoul, "soul");
        this.folder((FluidObject<?>)TinkerFluids.honey, "food");
        this.tintedStew((FluidObject<?>)TinkerFluids.beetrootSoup).color(-8120819);
        this.tintedStew((FluidObject<?>)TinkerFluids.mushroomStew).color(-3306385);
        this.tintedStew((FluidObject<?>)TinkerFluids.rabbitStew).color(-6796756);
        this.tintedStew((FluidObject<?>)TinkerFluids.meatSoup).color(-2081227);
        this.molten((FluidObject<?>)TinkerFluids.moltenGlass);
        this.named((FluidObject<?>)TinkerFluids.blazingBlood, "molten/blaze");
        this.tintedStone((FluidObject<?>)TinkerFluids.searedStone).color(-11580857);
        this.tintedStone((FluidObject<?>)TinkerFluids.scorchedStone).color(-12701655);
        this.tintedStone((FluidObject<?>)TinkerFluids.moltenClay).color(-6594491);
        this.stone((FluidObject<?>)TinkerFluids.moltenPorcelain);
        this.stone((FluidObject<?>)TinkerFluids.moltenObsidian);
        this.tintedStone((FluidObject<?>)TinkerFluids.moltenEnder).color(-15704495);
        this.ore((FluidObject<?>)TinkerFluids.moltenDiamond);
        this.ore((FluidObject<?>)TinkerFluids.moltenEmerald);
        this.ore((FluidObject<?>)TinkerFluids.moltenAmethyst);
        this.ore((FluidObject<?>)TinkerFluids.moltenQuartz);
        this.tintedStone((FluidObject<?>)TinkerFluids.moltenDebris).color(-12509675);
        this.ore((FluidObject<?>)TinkerFluids.moltenCopper);
        this.ore((FluidObject<?>)TinkerFluids.moltenIron);
        this.ore((FluidObject<?>)TinkerFluids.moltenGold);
        this.ore((FluidObject<?>)TinkerFluids.moltenCobalt);
        this.alloy((FluidObject<?>)TinkerFluids.moltenSlimesteel);
        this.alloy((FluidObject<?>)TinkerFluids.moltenAmethystBronze);
        this.alloy((FluidObject<?>)TinkerFluids.moltenPigIron);
        this.alloy((FluidObject<?>)TinkerFluids.moltenRoseGold);
        this.alloy((FluidObject<?>)TinkerFluids.moltenManyullyn);
        this.alloy((FluidObject<?>)TinkerFluids.moltenHepatizon);
        this.alloy((FluidObject<?>)TinkerFluids.moltenQueensSlime);
        this.alloy((FluidObject<?>)TinkerFluids.moltenNetherite);
        this.alloy((FluidObject<?>)TinkerFluids.moltenSoulsteel);
        this.alloy((FluidObject<?>)TinkerFluids.moltenKnightslime);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenAluminum);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenLead);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenNickel);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenOsmium);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenPlatinum);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenSilver);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenTin);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenTungsten);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenUranium);
        this.compatOre((FluidObject<?>)TinkerFluids.moltenZinc);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenBrass);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenBronze);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenConstantan);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenElectrum);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenInvar);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenPewter);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenSteel);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenEnderium);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenLumium);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenSignalum);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenRefinedObsidian);
        this.compatAlloy((FluidObject<?>)TinkerFluids.moltenRefinedGlowstone);
    }

    private FluidTexture.Builder root(FluidObject<?> fluid) {
        return this.texture(fluid).wrapId("fluid/", "/", false, false);
    }

    private FluidTexture.Builder folder(FluidObject<?> fluid, String folder) {
        return this.texture(fluid).wrapId("fluid/" + folder + "/", "/", false, false);
    }

    private FluidTexture.Builder named(FluidObject<?> fluid, String name) {
        return this.texture(fluid).textures(TConstruct.getResource("fluid/" + name + "/"), false, false);
    }

    private FluidTexture.Builder slime(FluidObject<?> fluid) {
        return this.folder(fluid, "slime");
    }

    private FluidTexture.Builder slime(FluidObject<?> fluid, String name) {
        return this.named(fluid, "slime/" + name);
    }

    private FluidTexture.Builder molten(FluidObject<?> fluid) {
        return this.named(fluid, "molten/" + TinkerFluids.withoutMolten(fluid));
    }

    private FluidTexture.Builder moltenFolder(FluidObject<?> fluid, String folder) {
        return this.named(fluid, "molten/" + folder + "/" + TinkerFluids.withoutMolten(fluid));
    }

    private FluidTexture.Builder stone(FluidObject<?> fluid) {
        return this.moltenFolder(fluid, "stone");
    }

    private FluidTexture.Builder ore(FluidObject<?> fluid) {
        return this.moltenFolder(fluid, "ore");
    }

    private FluidTexture.Builder alloy(FluidObject<?> fluid) {
        return this.moltenFolder(fluid, "alloy");
    }

    private FluidTexture.Builder compatOre(FluidObject<?> fluid) {
        return this.moltenFolder(fluid, "compat_ore");
    }

    private FluidTexture.Builder compatAlloy(FluidObject<?> fluid) {
        return this.moltenFolder(fluid, "compat_alloy");
    }

    private FluidTexture.Builder tintedStew(FluidObject<?> fluid) {
        return this.named(fluid, "food/stew");
    }

    private FluidTexture.Builder tintedStone(FluidObject<?> fluid) {
        return this.named(fluid, "molten/stone");
    }

    public String m_6055_() {
        return "Tinkers' Construct Fluid Texture Providers";
    }
}

