/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.integration.emi.recipe;

import com.chefmooon.ubesdelight.integration.emi.UDRecipeCategories;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BakingMatEmiRecipe
implements EmiRecipe {
    ResourceLocation BACKGROUND = new ResourceLocation("ubesdelight", "textures/gui/emi/baking_mat.png");
    private final ResourceLocation id;
    private final EmiIngredient tool;
    private final List<EmiIngredient> inputs;
    private final List<EmiIngredient> processStages;
    private final List<EmiStack> outputs;

    public BakingMatEmiRecipe(ResourceLocation id, EmiIngredient tool, List<EmiIngredient> inputs, List<EmiIngredient> processStages, List<EmiStack> outputs) {
        this.id = id;
        this.tool = tool;
        this.inputs = inputs;
        this.processStages = processStages;
        this.outputs = outputs;
    }

    public EmiRecipeCategory getCategory() {
        return UDRecipeCategories.BAKING_MAT;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.tool);
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputsMandatory = new ArrayList<EmiStack>();
        for (EmiStack stack : this.outputs) {
            if (stack.getChance() != 1.0f) continue;
            outputsMandatory.add(stack);
        }
        return outputsMandatory;
    }

    public int getDisplayWidth() {
        return 151;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        ArrayList<EmiStack> outputsMandatory = new ArrayList<EmiStack>();
        ArrayList<EmiStack> outputsChance = new ArrayList<EmiStack>();
        for (EmiStack stack : this.outputs) {
            if (stack.getChance() == 1.0f) {
                outputsMandatory.add(stack);
                continue;
            }
            outputsChance.add(stack);
        }
        widgets.addTexture(this.BACKGROUND, 0, 0, 149, 56, 6, 9);
        widgets.addSlot(this.tool, 57, 0).drawBack(false);
        for (int i = 0; i < this.inputs.size(); ++i) {
            Pair<Integer, Integer> slotLoc = BakingMatEmiRecipe.getInputItemOffset(19, 19, i);
            widgets.addSlot(this.inputs.get(i), ((Integer)slotLoc.getFirst()).intValue(), ((Integer)slotLoc.getSecond()).intValue()).customBackground(this.BACKGROUND, 0, 80, 18, 18);
        }
        if (this.processStages.size() > 0) {
            for (int j = 0; j < this.processStages.size(); ++j) {
                widgets.addSlot(this.processStages.get(j), 57 + j * 19, 38).customBackground(this.BACKGROUND, 0, 80, 18, 18);
            }
        }
        for (int k = 0; k < outputsMandatory.size(); ++k) {
            widgets.addSlot((EmiIngredient)outputsMandatory.get(k), 78 + k * 19, 19).customBackground(this.BACKGROUND, 0, 80, 18, 18).recipeContext((EmiRecipe)this);
        }
        for (int l = 0; l < outputsChance.size(); ++l) {
            widgets.addSlot((EmiIngredient)outputsChance.get(l), 78 + l * 19, 0).customBackground(this.BACKGROUND, 18, 80, 18, 18).recipeContext((EmiRecipe)this);
        }
    }

    public static Pair<Integer, Integer> getInputItemOffset(int x, int y, int index) {
        int xOffset = 19;
        int yOffset = 19;
        ArrayList<Pair> listOfPairs = new ArrayList<Pair>(List.of(Pair.of((Object)x, (Object)y), Pair.of((Object)(x + 19), (Object)y), Pair.of((Object)(x - 19), (Object)y), Pair.of((Object)x, (Object)(y - 19)), Pair.of((Object)x, (Object)(y + 19)), Pair.of((Object)(x + 19), (Object)(y - 19)), Pair.of((Object)(x - 19), (Object)(y - 19)), Pair.of((Object)(x + 19), (Object)(y + 19)), Pair.of((Object)(x - 19), (Object)(y + 19))));
        return (Pair)listOfPairs.get(index);
    }
}

