/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.forge;

import com.chefmooon.ubesdelight.common.block.BakingMatBlock;
import com.chefmooon.ubesdelight.common.block.entity.forge.BakingMatBlockEntityImpl;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BakingMatBlockImpl
extends BakingMatBlock {
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BakingMatBlockEntityImpl) {
            BakingMatBlockEntityImpl bakingMatBlockEntity = (BakingMatBlockEntityImpl)blockEntity;
            return bakingMatBlockEntity.getItemsQuantity();
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = InteractionResult.PASS;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BakingMatBlockEntityImpl)) {
            return result;
        }
        BakingMatBlockEntityImpl bakingMatBlockEntity = (BakingMatBlockEntityImpl)blockEntity;
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack offHandStack = player.m_21206_();
        if (heldStack.m_41720_() instanceof ShearsItem || heldStack.m_41720_() instanceof TridentItem) {
            return result;
        }
        boolean isValidTool = heldStack.m_41720_() instanceof DiggerItem;
        if (!bakingMatBlockEntity.isEmpty() && !heldStack.m_41619_() && isValidTool && this.tryProcessBakingMatUsingToolInHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.m_61143_((Property)BakingMatBlock.PROCESSING)).booleanValue() && !isValidTool) {
            if (!bakingMatBlockEntity.isFull() && !heldStack.m_41619_()) {
                return this.tryAddItemFromPlayerHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand);
            }
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && !bakingMatBlockEntity.isEmpty() && heldStack.m_41619_()) {
                return this.tryRemoveItemFromPlayerHand(level, bakingMatBlockEntity, heldStack, offHandStack, player, hand);
            }
        }
        return result;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BakingMatBlockEntityImpl) {
            BakingMatBlockEntityImpl bakingMat = (BakingMatBlockEntityImpl)tileEntity;
            if (!((Boolean)state.m_61143_((Property)PROCESSING)).booleanValue()) {
                Containers.m_19010_((Level)level, (BlockPos)pos, bakingMat.getItems());
            } else {
                state.m_61124_((Property)PROCESSING, (Comparable)Boolean.valueOf(false));
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private InteractionResult tryAddItemFromPlayerHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        InteractionResult result = InteractionResult.PASS;
        if (heldStack.m_41619_()) {
            return result;
        }
        if (bakingMatBlockEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
            level.m_5594_(null, bakingMatBlockEntity.m_58899_(), UbesDelightSounds.BLOCK_BAKING_MAT_ADD.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    private InteractionResult tryRemoveItemFromPlayerHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        BlockPos pos = bakingMatBlockEntity.m_58899_();
        if (!bakingMatBlockEntity.isEmpty()) {
            if (player.m_7500_()) {
                bakingMatBlockEntity.removeItem();
            } else if (!player.m_150109_().m_36054_(bakingMatBlockEntity.removeItem())) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)bakingMatBlockEntity.removeItem());
            }
            level.m_5594_(null, bakingMatBlockEntity.m_58899_(), UbesDelightSounds.BLOCK_BAKING_MAT_REMOVE.get(), SoundSource.BLOCKS, 0.25f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryProcessBakingMatUsingToolInHand(Level level, BakingMatBlockEntityImpl bakingMatBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        InteractionResult result = InteractionResult.PASS;
        if (heldStack.m_41720_() instanceof DiggerItem && bakingMatBlockEntity.processItemUsingTool(heldStack, player)) {
            return InteractionResult.SUCCESS;
        }
        return result;
    }
}

