/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.block.LemongrassLeafCropBlock;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LemongrassStalkCropBlock
extends CropBlock {
    public static final IntegerProperty LEMONGRASS_AGE = BlockStateProperties.f_61408_;
    public static final BooleanProperty SUPPORTING = BooleanProperty.m_61465_((String)"supporting");
    public static final int MAX_AGE = 5;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public LemongrassStalkCropBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60978_(0.2f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)SUPPORTING) == false || !this.m_52307_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 6 && (age = this.m_52305_(state)) <= this.m_7419_() && random.m_188503_((int)(25.0f / (growthSpeed = LemongrassStalkCropBlock.getGrowthSpeed(state.m_60734_(), (BlockGetter)level, pos))) + 1) == 0) {
            if (age == this.m_7419_()) {
                LemongrassLeafCropBlock lemongrassUpper = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                if (lemongrassUpper.m_49966_().m_60710_((LevelReader)level, pos.m_7494_()) && level.m_46859_(pos.m_7494_())) {
                    level.m_46597_(pos.m_7494_(), lemongrassUpper.m_49966_());
                }
            } else {
                level.m_46597_(pos, this.withAge(age + 1));
            }
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean northSouth;
        float growthSpeed = 1.0f;
        BlockPos blockPos = pos.m_7495_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                float farmlandBonus = 0.0f;
                BlockState blockStateBelow = level.m_8055_(blockPos.m_7918_(x, 0, y));
                if (blockStateBelow.m_60713_(Blocks.f_50093_)) {
                    farmlandBonus = 1.0f;
                    if (blockStateBelow.m_61138_((Property)FarmBlock.f_53243_) && (Integer)blockStateBelow.m_61143_((Property)FarmBlock.f_53243_) > 0) {
                        farmlandBonus = 3.0f;
                    }
                }
                if (x != 0 || y != 0) {
                    farmlandBonus /= 4.0f;
                }
                growthSpeed += farmlandBonus;
            }
        }
        BlockPos blockPosNorth = pos.m_122012_();
        BlockPos blockPosSouth = pos.m_122019_();
        BlockPos blockPosWest = pos.m_122024_();
        BlockPos blockPosEast = pos.m_122029_();
        boolean eastWest = level.m_8055_(blockPosWest).m_60713_(block) || level.m_8055_(blockPosEast).m_60713_(block);
        boolean bl = northSouth = level.m_8055_(blockPosNorth).m_60713_(block) || level.m_8055_(blockPosSouth).m_60713_(block);
        if (eastWest && northSouth) {
            growthSpeed /= 2.0f;
        } else {
            boolean diagonal;
            boolean bl2 = diagonal = level.m_8055_(blockPosWest.m_122012_()).m_60713_(block) || level.m_8055_(blockPosEast.m_122012_()).m_60713_(block) || level.m_8055_(blockPosEast.m_122019_()).m_60713_(block) || level.m_8055_(blockPosWest.m_122019_()).m_60713_(block);
            if (diagonal) {
                growthSpeed /= 2.0f;
            }
        }
        return growthSpeed;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_) || state.m_204336_(CommonTags.C_FARMLAND) || state.m_60713_(BuiltInRegistryUtil.getBlock(new ResourceLocation("farmersdelight", "rich_soil_farmland")));
    }

    protected IntegerProperty m_7959_() {
        return LEMONGRASS_AGE;
    }

    public int m_52305_(BlockState state) {
        return (Integer)state.m_61143_((Property)this.m_7959_());
    }

    public int m_7419_() {
        return 5;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return BuiltInRegistryUtil.getItemStack(UbesDelightItems.LEMONGRASS_SEEDS);
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEMONGRASS_AGE, SUPPORTING});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        if (!state.m_60795_() && facing == Direction.UP) {
            return (BlockState)state.m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(this.isSupportingLemongrass(facingState)));
        }
        return state;
    }

    public boolean isSupportingLemongrass(BlockState topState) {
        return topState.m_60734_() == BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = level.m_8055_(pos.m_7494_());
        if (upperState.m_60734_() instanceof LemongrassLeafCropBlock) {
            return !((LemongrassLeafCropBlock)upperState.m_60734_()).m_52307_(upperState);
        }
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected int m_7125_(Level level) {
        return Mth.m_216271_((RandomSource)level.f_46441_, (int)1, (int)5);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.m_52305_(state) + this.m_7125_((Level)level), 6);
        if (ageGrowth <= this.m_7419_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            BlockState top = level.m_8055_(pos.m_7494_());
            if (top.m_60734_() == BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP)) {
                BonemealableBlock growable = (BonemealableBlock)level.m_8055_(pos.m_7494_()).m_60734_();
                if (growable.m_7370_((LevelReader)level, pos.m_7494_(), top, false)) {
                    growable.m_214148_(level, level.f_46441_, pos.m_7494_(), top);
                }
            } else {
                LemongrassLeafCropBlock lemongrassLeafCropBlock = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                int remainingGrowth = ageGrowth - this.m_7419_() - 1;
                if (lemongrassLeafCropBlock.m_49966_().m_60710_((LevelReader)level, pos.m_7494_()) && level.m_46859_(pos.m_7494_())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(this.m_7419_())));
                    level.m_7731_(pos.m_7494_(), (BlockState)lemongrassLeafCropBlock.m_49966_().m_61124_((Property)LemongrassLeafCropBlock.lEMONGRASS_AGE, (Comparable)Integer.valueOf(remainingGrowth)), 2);
                }
            }
        }
    }
}

