/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class KalanBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public KalanBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(UbesDelightBlocks.litBlockEmission(13)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldStack.m_204117_(ItemTags.f_271138_)) {
                this.extinguish(state, level, pos);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem == Items.f_42447_) {
                if (!level.m_5776_()) {
                    level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, level, pos);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void extinguish(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f, false);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT, FACING});
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(UbesDelightDamageTypes.getSimpleDamageSource(level, UbesDelightDamageTypes.KALAN_BURN), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)LIT) == false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos neighborPos;
                BlockState neighborState;
                if (random.m_188503_(2) > 0 || (neighborState = level.m_8055_(neighborPos = pos.m_121945_(direction))).m_60804_((BlockGetter)level, neighborPos)) continue;
                double xOffset = (double)direction.m_122429_() * 0.52;
                double zOffset = (double)direction.m_122431_() * 0.52;
                double yOffset = random.m_188500_() * 6.0 / 24.0 + 0.3;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }
}

