/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife.compat.aether;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.UUID;
import net.brnbrd.delightful.common.item.DelightfulTiers;
import net.brnbrd.delightful.common.item.knife.compat.aether.AetherKnifeItem;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ZaniteKnifeItem
extends AetherKnifeItem {
    private final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("CAE1DE8D-8A7F-4391-B6BD-C060B1DD49C5");

    public ZaniteKnifeItem(Item.Properties properties) {
        super(DelightfulItemTags.GEMS_ZANITE, DelightfulTiers.ZANITE, properties, new ChatFormatting[0]);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
            attributeBuilder.putAll(map);
            attributeBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.DAMAGE_MODIFIER_UUID, "Damage modifier", (double)this.calculateIncrease((Multimap<Attribute, AttributeModifier>)map, stack), AttributeModifier.Operation.ADDITION));
            return attributeBuilder.build();
        }
        return map;
    }

    private int calculateIncrease(Multimap<Attribute, AttributeModifier> map, ItemStack stack) {
        double baseDamage = 0.0;
        Iterator it = map.get((Object)Attributes.f_22281_).stream().iterator();
        while (it.hasNext()) {
            AttributeModifier modifier = (AttributeModifier)it.next();
            baseDamage += modifier.m_22218_();
        }
        double boostedDamage = baseDamage * (2.0 * (double)stack.m_41773_() / (double)stack.m_41776_() + 0.5);
        if ((boostedDamage -= baseDamage) < 0.0) {
            boostedDamage = 0.0;
        }
        return (int)Math.round(boostedDamage);
    }
}

