/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.data.provider.model;

import com.crypticmushroom.minecraft.midnight.common.block.CacheBlock;
import com.crypticmushroom.minecraft.midnight.common.block.HorizontalFacingBlock;
import com.crypticmushroom.minecraft.midnight.common.block.NestedEggsBlock;
import com.crypticmushroom.minecraft.midnight.common.block.NightGrassBlock;
import com.crypticmushroom.minecraft.midnight.common.block.NightMyceliumBlock;
import com.crypticmushroom.minecraft.midnight.common.block.ShroomCapBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.DirectionalBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.HangingLeavesBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.MnDoublePlantBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.NightReedBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.data.provider.model.MnBlockModelProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.model.MnItemModelProvider;
import com.crypticmushroom.minecraft.registry.data.provider.model.CrypticBlockModelProvider;
import com.crypticmushroom.minecraft.registry.data.provider.model.CrypticBlockStateProvider;
import com.crypticmushroom.minecraft.registry.data.provider.model.CrypticItemModelProvider;
import com.crypticmushroom.minecraft.registry.data.provider.model.ICrypticModelProvider;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

public class MnBlockStateProvider
extends CrypticBlockStateProvider<MnBlockModelProvider, MnItemModelProvider> {
    public static final BlockStateBuilderAction<NightGrassBlock> NIGHT_GRASS_BLOCK = (states, block) -> states.simpleBlockRotateY((Supplier<? extends Block>)block, ((MnBlockModelProvider)states.models()).grassBlock((Supplier<? extends Block>)block, states.texture((Supplier)block, "side"), states.texture((Supplier)MnBlocks.NIGHT_DIRT), states.texture((Supplier)block, "top"), states.texture((Supplier)block, "overlay")));
    public static final BlockStateBuilderAction<NightMyceliumBlock> NIGHT_MYCELIUM = (states, block) -> states.simpleBlockRotateY((Supplier<? extends Block>)block, ((MnBlockModelProvider)states.models()).cubeBottomTop((Supplier)block, states.texture((Supplier)block, "side"), states.texture((Supplier)MnBlocks.NIGHTSTONE), states.texture((Supplier)block, "top")));
    public static final BlockStateBuilderAction<HorizontalFacingBlock> INFESTED_GLOB_FUNGUS_STEM = (states, block) -> states.horizontalFacingBlock((Supplier<? extends HorizontalFacingBlock>)block, ((MnBlockModelProvider)states.models()).cubeFrontSided((Supplier)block, states.texture((Supplier)block), states.blockFolder("glob_fungus_stem", true), states.blockFolder("glob_fungus_stem", true), states.blockFolder("glob_fungus_stem", true)), true);
    public static final BlockStateBuilderAction<Block> PILLAR_CRYSTALS = (states, block) -> states.simpleBlock((Supplier)block, (ModelFile)((MnBlockModelProvider)states.models()).cubeBottomTop((Supplier)block, states.texture((Supplier)block), states.texture((Supplier)block, "end"), states.texture((Supplier)block, "end")));

    public MnBlockStateProvider(GatherDataEvent event) {
        super("midnight", event, (CrypticBlockModelProvider)new MnBlockModelProvider(event){

            protected void registerModels() {
            }
        }, (CrypticItemModelProvider)new MnItemModelProvider(event){

            protected void registerModels() {
            }
        });
    }

    public VariantBlockStateBuilder hangingLeavesBlock(Supplier<? extends HangingLeavesBushBlock> block) {
        return this.hangingLeavesBlock(block, ((MnBlockModelProvider)this.models()).hangingLeavesRoot(block), ((MnBlockModelProvider)this.models()).hangingLeavesEnd(block), ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder hangingLeavesBlock(Supplier<? extends HangingLeavesBushBlock> block, ICrypticModelProvider.RenderType renderType) {
        return this.hangingLeavesBlock(block, ((MnBlockModelProvider)this.models()).hangingLeavesRoot(block), ((MnBlockModelProvider)this.models()).hangingLeavesEnd(block), renderType);
    }

    public <B extends HangingLeavesBushBlock> VariantBlockStateBuilder hangingLeavesBlock(Supplier<B> block, BlockModelBuilder root, BlockModelBuilder end) {
        return this.hangingLeavesBlock(block, root, end, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public <B extends HangingLeavesBushBlock> VariantBlockStateBuilder hangingLeavesBlock(Supplier<B> block, BlockModelBuilder root, BlockModelBuilder end, ICrypticModelProvider.RenderType renderType) {
        HangingLeavesBushBlock b = (HangingLeavesBushBlock)block.get();
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)HangingLeavesBushBlock.END, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)end.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType)).addModel()).partialState().with((Property)HangingLeavesBushBlock.END, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)root.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType)).addModel();
    }

    public <B extends DirectionalBushBlock> VariantBlockStateBuilder directionalPlantBlock(Supplier<B> block, BlockModelBuilder model, boolean uvLock) {
        return this.directionalPlantBlock(block, model, uvLock, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public <B extends DirectionalBushBlock> VariantBlockStateBuilder directionalPlantBlock(Supplier<B> block, BlockModelBuilder model, boolean uvLock, ICrypticModelProvider.RenderType renderType) {
        DirectionalBushBlock b = (DirectionalBushBlock)block.get();
        BlockModelBuilder modelFile = (BlockModelBuilder)model.renderType((ResourceLocation)renderType);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)b);
        for (Direction direction : Direction.values()) {
            int x = 0;
            int y = 0;
            if (direction == Direction.DOWN) {
                x = 180;
            } else if (direction != Direction.UP) {
                x = 90;
                y = direction.m_122424_().m_122416_() * 90;
            }
            builder = (VariantBlockStateBuilder)builder.partialState().with((Property)b.getFacingProperty(), (Comparable)direction).modelForState().modelFile((ModelFile)modelFile).uvLock(uvLock).rotationX(x).rotationY(y).addModel();
        }
        return builder;
    }

    public VariantBlockStateBuilder nightReed(Supplier<? extends NightReedBlock> block) {
        NightReedBlock b = block.get();
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)NightReedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)).with((Property)NightReedBlock.END, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((MnBlockModelProvider)this.models()).cross(this.name((Block)b), this.texture((Block)b)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).addModel()).partialState().with((Property)NightReedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)).with((Property)NightReedBlock.END, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((MnBlockModelProvider)this.models()).cross(this.name((Block)b, "flooded"), this.texture((Block)b, "flooded")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).addModel()).partialState().with((Property)NightReedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)).with((Property)NightReedBlock.END, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((MnBlockModelProvider)this.models()).cross(this.name((Block)b, "end"), this.texture((Block)b, "end")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).addModel()).partialState().with((Property)NightReedBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)).with((Property)NightReedBlock.END, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((MnBlockModelProvider)this.models()).cross(this.name((Block)b, "flooded_end"), this.texture((Block)b, "flooded_end")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).addModel();
    }

    public <B extends Block> VariantBlockStateBuilder growablePlant(Supplier<B> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model, BooleanProperty property) {
        return this.growablePlant(block, model, property, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public <B extends Block> VariantBlockStateBuilder growablePlant(Supplier<B> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model, BooleanProperty property, ICrypticModelProvider.RenderType renderType) {
        Block b = (Block)block.get();
        BlockModelBuilder normal = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name(b), this.texture(b)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder grown = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name(b, "grown"), this.texture(b, "grown")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(b).partialState().with((Property)property, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)grown).addModel()).partialState().with((Property)property, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)normal).addModel();
    }

    public VariantBlockStateBuilder growablePlantRotY(Supplier<? extends Block> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model, BooleanProperty property) {
        return this.growablePlantRotY(block, model, property, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder growablePlantRotY(Supplier<? extends Block> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model, BooleanProperty property, ICrypticModelProvider.RenderType renderType) {
        Block b = block.get();
        BlockModelBuilder normal = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name(b), this.texture(b)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder grown = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name(b, "grown"), this.texture(b, "grown")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        return this.getVariantBuilder(b).partialState().with((Property)property, (Comparable)Boolean.valueOf(true)).setModels(ConfiguredModel.allYRotations((ModelFile)grown, (int)0, (boolean)false)).partialState().with((Property)property, (Comparable)Boolean.valueOf(false)).setModels(ConfiguredModel.allYRotations((ModelFile)normal, (int)0, (boolean)false));
    }

    public VariantBlockStateBuilder simpleBlockRotateY(Supplier<? extends Block> block, BlockModelBuilder model) {
        return this.simpleBlockRotateY(block, model, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder simpleBlockRotateY(Supplier<? extends Block> block, BlockModelBuilder model, ICrypticModelProvider.RenderType renderType) {
        Block b = block.get();
        BlockModelBuilder modelFile = (BlockModelBuilder)model.renderType((ResourceLocation)renderType);
        return this.getVariantBuilder(b).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)modelFile, (int)0, (boolean)false));
    }

    public VariantBlockStateBuilder simpleBlockRotateXY(Supplier<? extends Block> block, BlockModelBuilder model) {
        return this.simpleBlockRotateXY(block, model, ICrypticModelProvider.RenderType.NONE);
    }

    public VariantBlockStateBuilder simpleBlockRotateXY(Supplier<? extends Block> block, BlockModelBuilder model, ICrypticModelProvider.RenderType renderType) {
        Block b = block.get();
        BlockModelBuilder modelFile = (BlockModelBuilder)model.renderType((ResourceLocation)renderType);
        return this.getVariantBuilder(b).forAllStates(state -> ConfiguredModel.allRotations((ModelFile)modelFile, (boolean)false));
    }

    public VariantBlockStateBuilder shroomShelfBlock(Supplier<? extends DirectionalBushBlock> block) {
        return this.shroomShelfBlock(block, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder shroomShelfBlock(Supplier<? extends DirectionalBushBlock> block, ICrypticModelProvider.RenderType renderType) {
        DirectionalBushBlock b = block.get();
        BlockModelBuilder fan = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).singleTexture(this.name((Block)b, "fan", "shelf"), this.blockFolder("fan", true), "fan", this.texture((Block)b)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder shelf = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).singleTexture(this.name((Block)b), this.blockFolder("shelf", true), "shelf", this.texture((Block)b)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)MnBlockStateProperties.FACING_EXCEPT_DOWN, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)fan).addModel()).partialState().with((Property)MnBlockStateProperties.FACING_EXCEPT_DOWN, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)shelf).addModel()).partialState().with((Property)MnBlockStateProperties.FACING_EXCEPT_DOWN, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)shelf).rotationY(90).addModel()).partialState().with((Property)MnBlockStateProperties.FACING_EXCEPT_DOWN, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)shelf).rotationY(180).addModel()).partialState().with((Property)MnBlockStateProperties.FACING_EXCEPT_DOWN, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)shelf).rotationY(270).addModel();
    }

    public VariantBlockStateBuilder nestedEggsBlock(Supplier<? extends NestedEggsBlock> block) {
        return this.nestedEggsBlock(block, ((MnBlockModelProvider)this.models())::nestedEggs, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder nestedEggsBlock(Supplier<? extends NestedEggsBlock> block, ICrypticModelProvider.RenderType renderType) {
        return this.nestedEggsBlock(block, ((MnBlockModelProvider)this.models())::nestedEggs, renderType);
    }

    public <B extends NestedEggsBlock> VariantBlockStateBuilder nestedEggsBlock(Supplier<B> block, BiFunction<B, Integer, BlockModelBuilder> model) {
        return this.nestedEggsBlock(block, model, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public <B extends NestedEggsBlock> VariantBlockStateBuilder nestedEggsBlock(Supplier<B> block, BiFunction<B, Integer, BlockModelBuilder> model, ICrypticModelProvider.RenderType renderType) {
        NestedEggsBlock b = (NestedEggsBlock)((Object)block.get());
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(b).partialState().with((Property)NestedEggsBlock.EGGS, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)model.apply((B)((Object)b), 1).renderType((ResourceLocation)renderType)).addModel()).partialState().with((Property)NestedEggsBlock.EGGS, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)model.apply((B)((Object)b), 2).renderType((ResourceLocation)renderType)).addModel()).partialState().with((Property)NestedEggsBlock.EGGS, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)model.apply((B)((Object)b), 3).renderType((ResourceLocation)renderType)).addModel()).partialState().with((Property)NestedEggsBlock.EGGS, (Comparable)Integer.valueOf(4)).modelForState().modelFile((ModelFile)model.apply((B)((Object)b), 4).renderType((ResourceLocation)renderType)).addModel();
    }

    public VariantBlockStateBuilder shroomCapBlock(Supplier<? extends ShroomCapBlock> block) {
        return this.shroomCapBlock(block, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder shroomCapBlock(Supplier<? extends ShroomCapBlock> block, ICrypticModelProvider.RenderType renderType) {
        ShroomCapBlock b = block.get();
        StateDefinition states = b.m_49965_();
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        ResourceLocation capTex = this.texture(b);
        ResourceLocation innerTex = this.texture(b, "inner");
        for (BlockState state : states.m_61056_()) {
            boolean down = (Boolean)state.m_61143_((Property)ShroomCapBlock.DOWN);
            ResourceLocation downTex = down ? capTex : innerTex;
            boolean up = (Boolean)state.m_61143_((Property)ShroomCapBlock.UP);
            ResourceLocation upTex = up ? capTex : innerTex;
            boolean north = (Boolean)state.m_61143_((Property)ShroomCapBlock.NORTH);
            ResourceLocation northTex = north ? capTex : innerTex;
            boolean south = (Boolean)state.m_61143_((Property)ShroomCapBlock.SOUTH);
            ResourceLocation southTex = south ? capTex : innerTex;
            boolean east = (Boolean)state.m_61143_((Property)ShroomCapBlock.EAST);
            ResourceLocation eastTex = east ? capTex : innerTex;
            boolean west = (Boolean)state.m_61143_((Property)ShroomCapBlock.WEST);
            ResourceLocation westTex = west ? capTex : innerTex;
            Object side = "";
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.UP)).booleanValue()) {
                side = (String)side + "u";
            }
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.DOWN)).booleanValue()) {
                side = (String)side + "d";
            }
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.NORTH)).booleanValue()) {
                side = (String)side + "n";
            }
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.EAST)).booleanValue()) {
                side = (String)side + "e";
            }
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.SOUTH)).booleanValue()) {
                side = (String)side + "s";
            }
            if (!((Boolean)state.m_61143_((Property)ShroomCapBlock.WEST)).booleanValue()) {
                side = (String)side + "w";
            }
            BlockModelBuilder model = (BlockModelBuilder)((MnBlockModelProvider)this.models()).cube(this.name(b, (String)side), downTex, upTex, northTex, southTex, eastTex, westTex).texture("particle", innerTex);
            model.renderType((ResourceLocation)renderType);
            builder = (VariantBlockStateBuilder)builder.partialState().with((Property)ShroomCapBlock.UP, (Comparable)Boolean.valueOf(up)).with((Property)ShroomCapBlock.DOWN, (Comparable)Boolean.valueOf(down)).with((Property)ShroomCapBlock.NORTH, (Comparable)Boolean.valueOf(north)).with((Property)ShroomCapBlock.SOUTH, (Comparable)Boolean.valueOf(south)).with((Property)ShroomCapBlock.EAST, (Comparable)Boolean.valueOf(east)).with((Property)ShroomCapBlock.WEST, (Comparable)Boolean.valueOf(west)).modelForState().modelFile((ModelFile)model).addModel();
        }
        return builder;
    }

    public VariantBlockStateBuilder cache(Supplier<? extends CacheBlock> block, Supplier<? extends Block> texture) {
        return this.cache(block, texture, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder cache(Supplier<? extends CacheBlock> block, Supplier<? extends Block> texture, ICrypticModelProvider.RenderType renderType) {
        CacheBlock b = block.get();
        ResourceLocation tex = this.texture(texture);
        ResourceLocation cache = this.texture(block);
        BlockModelBuilder model = (BlockModelBuilder)((MnBlockModelProvider)this.models()).cube((Block)b, tex, tex, cache, tex, tex, tex).texture("particle", tex);
        model.renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)CacheBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)CacheBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)model).addModel()).partialState().with((Property)CacheBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile((ModelFile)model).addModel()).partialState().with((Property)CacheBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile((ModelFile)model).addModel();
    }

    public MultiPartBlockStateBuilder fire(Supplier<? extends BaseFireBlock> block) {
        return this.fire(block, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public MultiPartBlockStateBuilder fire(Supplier<? extends BaseFireBlock> block, ICrypticModelProvider.RenderType renderType) {
        BaseFireBlock b = block.get();
        BlockModelBuilder floor0 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "floor0"), this.blockFolder("template_fire_floor", false))).texture("fire", this.texture((Block)b, "0"));
        ((BlockModelBuilder)floor0.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder floor1 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "floor1"), this.blockFolder("template_fire_floor", false))).texture("fire", this.texture((Block)b, "1"));
        ((BlockModelBuilder)floor1.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder side0 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "side0"), this.blockFolder("template_fire_side", false))).texture("fire", this.texture((Block)b, "0"));
        ((BlockModelBuilder)side0.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder side1 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "side1"), this.blockFolder("template_fire_side", false))).texture("fire", this.texture((Block)b, "1"));
        ((BlockModelBuilder)side1.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder sideAlt0 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "side_alt0"), this.blockFolder("template_fire_side_alt", false))).texture("fire", this.texture((Block)b, "0"));
        ((BlockModelBuilder)sideAlt0.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder sideAlt1 = (BlockModelBuilder)((BlockModelBuilder)((MnBlockModelProvider)this.models()).withExistingParent(this.name((Block)b, "side_alt1"), this.blockFolder("template_fire_side_alt", false))).texture("fire", this.texture((Block)b, "1"));
        ((BlockModelBuilder)sideAlt1.renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        return ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)b).part().modelFile((ModelFile)floor0).nextModel().modelFile((ModelFile)floor1).addModel()).end().part().modelFile((ModelFile)side0).nextModel().modelFile((ModelFile)side1).nextModel().modelFile((ModelFile)sideAlt0).nextModel().modelFile((ModelFile)sideAlt1).addModel()).end().part().modelFile((ModelFile)side0).rotationY(90).nextModel().modelFile((ModelFile)side1).rotationY(90).nextModel().modelFile((ModelFile)sideAlt0).rotationY(90).nextModel().modelFile((ModelFile)sideAlt1).rotationY(90).addModel()).end().part().modelFile((ModelFile)side0).rotationY(180).nextModel().modelFile((ModelFile)side1).rotationY(180).nextModel().modelFile((ModelFile)sideAlt0).rotationY(180).nextModel().modelFile((ModelFile)sideAlt1).rotationY(180).addModel()).end().part().modelFile((ModelFile)side0).rotationY(270).nextModel().modelFile((ModelFile)side1).rotationY(270).nextModel().modelFile((ModelFile)sideAlt0).rotationY(270).nextModel().modelFile((ModelFile)sideAlt1).rotationY(270).addModel()).end();
    }

    public VariantBlockStateBuilder craftingTable(Supplier<? extends CraftingTableBlock> block, Supplier<? extends Block> texture) {
        return this.craftingTable(block, texture, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public <B extends CraftingTableBlock> VariantBlockStateBuilder craftingTable(Supplier<B> block, Supplier<? extends Block> texture, ICrypticModelProvider.RenderType renderType) {
        ResourceLocation base = this.texture(texture);
        ResourceLocation front = this.texture(block, "front");
        ResourceLocation side = this.texture(block, "side");
        ResourceLocation top = this.texture(block, "top");
        return this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((MnBlockModelProvider)this.models()).cube(block, base, top, front, side, side, front).texture("particle", front)).renderType((ResourceLocation)renderType));
    }

    public VariantBlockStateBuilder furnace(Supplier<? extends AbstractFurnaceBlock> block) {
        return this.furnace(block, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder furnace(Supplier<? extends AbstractFurnaceBlock> block, ICrypticModelProvider.RenderType renderType) {
        AbstractFurnaceBlock b = block.get();
        ResourceLocation top = this.texture((Block)b, "top");
        ResourceLocation side = this.texture((Block)b, "side");
        ResourceLocation front = this.texture((Block)b, "front");
        ResourceLocation frontOn = this.texture((Block)b, "front_on");
        BlockModelBuilder model = ((MnBlockModelProvider)this.models()).orientable(this.name((Block)b), side, front, top);
        BlockModelBuilder modelOn = ((MnBlockModelProvider)this.models()).orientable(this.name((Block)b, "on"), side, frontOn, top);
        model.renderType((ResourceLocation)renderType);
        modelOn.renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.NORTH).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.EAST).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.SOUTH).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.WEST).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.NORTH).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelOn).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.EAST).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelOn).rotationY(90).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.SOUTH).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelOn).rotationY(180).addModel()).partialState().with((Property)AbstractFurnaceBlock.f_48683_, (Comparable)Direction.WEST).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelOn).rotationY(270).addModel();
    }

    public VariantBlockStateBuilder horizontalFacingBlock(Supplier<? extends HorizontalFacingBlock> block, BlockModelBuilder model, boolean uvLock) {
        return this.horizontalFacingBlock(block, model, uvLock, ICrypticModelProvider.RenderType.DEFAULT);
    }

    public VariantBlockStateBuilder horizontalFacingBlock(Supplier<? extends HorizontalFacingBlock> block, BlockModelBuilder model, boolean uvLock, ICrypticModelProvider.RenderType renderType) {
        HorizontalFacingBlock b = block.get();
        BlockModelBuilder modelFile = (BlockModelBuilder)model.renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)HorizontalFacingBlock.f_54117_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)modelFile).uvLock(uvLock).addModel()).partialState().with((Property)HorizontalFacingBlock.f_54117_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)modelFile).rotationY(90).uvLock(uvLock).addModel()).partialState().with((Property)HorizontalFacingBlock.f_54117_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)modelFile).rotationY(180).uvLock(uvLock).addModel()).partialState().with((Property)HorizontalFacingBlock.f_54117_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)modelFile).rotationY(270).uvLock(uvLock).addModel();
    }

    public VariantBlockStateBuilder tallPlantBlock(Supplier<? extends MnDoublePlantBlock> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model) {
        return this.tallPlantBlock(block, model, ICrypticModelProvider.RenderType.CUTOUT);
    }

    public VariantBlockStateBuilder tallPlantBlock(Supplier<? extends MnDoublePlantBlock> block, BiFunction<String, ResourceLocation, BlockModelBuilder> model, ICrypticModelProvider.RenderType renderType) {
        MnDoublePlantBlock b = block.get();
        BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name((Block)b, "lower"), this.texture((Block)b, "lower")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)model.apply(this.name((Block)b, "upper"), this.texture((Block)b, "upper")).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT)).renderType((ResourceLocation)renderType);
        return (VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)b).partialState().with((Property)MnDoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)lower).addModel()).partialState().with((Property)MnDoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)upper).addModel();
    }

    public static interface BlockStateBuilderAction<B extends Block>
    extends BiFunction<MnBlockStateProvider, RegistryObject<B>, IGeneratedBlockState> {
    }
}

