/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.data.provider.model;

import com.crypticmushroom.minecraft.midnight.common.block.NestedEggsBlock;
import com.crypticmushroom.minecraft.registry.data.provider.model.CrypticBlockModelProvider;
import com.crypticmushroom.minecraft.registry.data.provider.model.ICrypticModelProvider;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Range;

public abstract class MnBlockModelProvider
extends CrypticBlockModelProvider {
    public MnBlockModelProvider(GatherDataEvent event) {
        super("midnight", event);
    }

    public BlockModelBuilder grassBlock(Supplier<? extends Block> block) {
        return this.grassBlock(block.get());
    }

    public BlockModelBuilder grassBlock(Supplier<? extends Block> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, ResourceLocation overlay) {
        return this.grassBlock(block.get(), side, bottom, top, overlay);
    }

    public BlockModelBuilder grassBlock(Block block) {
        return this.grassBlock(block, this.texture((ItemLike)block, "side"), this.texture((ItemLike)block, "bottom"), this.texture((ItemLike)block, "top"), this.texture((ItemLike)block, "overlay"));
    }

    public BlockModelBuilder grassBlock(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, ResourceLocation overlay) {
        return this.grassBlock(this.name((ItemLike)block), side, bottom, top, overlay);
    }

    public BlockModelBuilder grassBlock(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, this.blockFolder("grass_block", true))).texture("top", top)).texture("bottom", bottom)).texture("side", side)).texture("overlay", overlay)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT_MIPPED);
    }

    public BlockModelBuilder hangingLeavesRoot(Supplier<? extends Block> block) {
        return this.hangingLeavesRoot(block.get());
    }

    public BlockModelBuilder hangingLeavesRoot(Block block) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(this.name((ItemLike)block), this.blockFolder("hanging_leaves", true))).texture("inner", this.texture((ItemLike)block, "inner"))).texture("outer", this.texture((ItemLike)block, "outer"));
    }

    public BlockModelBuilder hangingLeavesEnd(Supplier<? extends Block> block) {
        return this.hangingLeavesEnd(block.get());
    }

    public BlockModelBuilder hangingLeavesEnd(Block block) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(this.name((ItemLike)block, "end"), this.blockFolder("hanging_leaves_end", true))).texture("inner", this.texture((ItemLike)block, "inner"))).texture("end", this.texture((ItemLike)block, "end"));
    }

    public BlockModelBuilder tintedCross(Supplier<? extends Block> block) {
        return this.tintedCross(block.get());
    }

    public BlockModelBuilder tintedCross(Block block) {
        return this.tintedCross(this.name((ItemLike)block), this.texture((ItemLike)block));
    }

    public BlockModelBuilder tintedCross(String name, ResourceLocation texture) {
        return (BlockModelBuilder)this.singleTexture(name, this.blockFolder("tinted_cross", false), "cross", texture).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public BlockModelBuilder singleLayerPlant(Supplier<? extends Block> block) {
        return this.singleLayerPlant(block.get());
    }

    public BlockModelBuilder singleLayerPlant(Block block) {
        return (BlockModelBuilder)this.singleTexture(this.name((ItemLike)block), this.blockFolder("layered_plant_1", true), "layer1", this.texture((ItemLike)block)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public Pair<BlockModelBuilder, BlockModelBuilder> doubleLayerPlant(Supplier<? extends Block> block) {
        return this.doubleLayerPlant(block.get());
    }

    public Pair<BlockModelBuilder, BlockModelBuilder> doubleLayerPlant(Block block) {
        BlockModelBuilder less = this.singleTexture(this.name((ItemLike)block), this.blockFolder("layered_plant_1", true), "layer1", this.texture((ItemLike)block));
        BlockModelBuilder more = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(this.name((ItemLike)block, "dense"), this.blockFolder("layered_plant_2", true))).texture("layer1", this.texture((ItemLike)block, "dense"))).texture("layer2", this.texture((ItemLike)block));
        return Pair.of((Object)less, (Object)more);
    }

    public BlockModelBuilder crystalotus(Supplier<? extends Block> block) {
        return this.crystalotus(block.get());
    }

    public BlockModelBuilder crystalotus(Block block) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(this.name((ItemLike)block), this.blockFolder("crystalotus_base", true))).texture("leaf", this.texture((ItemLike)block, "leaf"))).texture("core", this.texture((ItemLike)block, "core"))).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public BlockModelBuilder flatPlant(Supplier<? extends Block> block) {
        return this.flatPlant(block.get());
    }

    public BlockModelBuilder flatPlant(Block block) {
        return this.flatPlant(this.name((ItemLike)block), this.texture((ItemLike)block));
    }

    public BlockModelBuilder flatPlant(String name, ResourceLocation texture) {
        return (BlockModelBuilder)this.singleTexture(name, this.blockFolder("flat_plant", true), "plant", texture).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public BlockModelBuilder moss(Supplier<? extends Block> block) {
        return this.moss(block.get());
    }

    public BlockModelBuilder moss(Block block) {
        return (BlockModelBuilder)this.moss(this.name((ItemLike)block), this.texture((ItemLike)block)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public BlockModelBuilder moss(String name, ResourceLocation texture) {
        return this.singleTexture(name, this.blockFolder("moss", true), "texture", texture);
    }

    public BlockModelBuilder ladder(Supplier<? extends LadderBlock> block) {
        return this.ladder(block.get());
    }

    public BlockModelBuilder ladder(LadderBlock block) {
        return (BlockModelBuilder)this.ladder(this.name((ItemLike)block), this.texture((ItemLike)block)).renderType((ResourceLocation)ICrypticModelProvider.RenderType.CUTOUT);
    }

    public BlockModelBuilder ladder(String name, ResourceLocation texture) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, this.texture((ItemLike)Blocks.f_50155_))).texture("particle", texture)).texture("texture", texture);
    }

    public BlockModelBuilder nestedEggs(Supplier<? extends NestedEggsBlock> block, @Range(from=1L, to=4L) int eggs) {
        return this.nestedEggs(block.get(), eggs);
    }

    public BlockModelBuilder nestedEggs(NestedEggsBlock block, @Range(from=1L, to=4L) int eggs) {
        assert (NestedEggsBlock.EGGS.m_6908_().contains(eggs));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(this.name((ItemLike)block, String.valueOf(eggs)), "block")).texture("all", this.texture((ItemLike)block))).texture("particle", this.texture((ItemLike)block))).element().from(5.0f, 0.0f, 3.0f).to(11.0f, 8.0f, 9.0f).allFaces((face, builder) -> {
            switch (face) {
                case NORTH: {
                    builder.uvs(0.0f, 3.0f, 3.0f, 7.0f).texture("#all");
                    break;
                }
                case EAST: {
                    builder.uvs(9.0f, 3.0f, 12.0f, 7.0f).texture("#all");
                    break;
                }
                case SOUTH: {
                    builder.uvs(6.0f, 3.0f, 9.0f, 7.0f).texture("#all");
                    break;
                }
                case WEST: {
                    builder.uvs(3.0f, 3.0f, 6.0f, 7.0f).texture("#all");
                    break;
                }
                case UP: {
                    builder.uvs(3.0f, 0.0f, 6.0f, 3.0f).texture("#all");
                    break;
                }
                case DOWN: {
                    builder.uvs(3.0f, 7.0f, 6.0f, 10.0f).texture("#all");
                }
            }
        }).end();
        if (eggs >= 2) {
            model.element().from(1.0f, 0.0f, 2.0f).to(5.0f, 6.0f, 6.0f).allFaces((face, builder) -> {
                switch (face) {
                    case NORTH: {
                        builder.uvs(7.0f, 11.0f, 9.0f, 13.5f).texture("#all");
                        break;
                    }
                    case EAST: {
                        builder.uvs(5.0f, 11.0f, 7.0f, 13.5f).texture("#all");
                        break;
                    }
                    case SOUTH: {
                        builder.uvs(11.0f, 11.0f, 13.0f, 13.5f).texture("#all");
                        break;
                    }
                    case WEST: {
                        builder.uvs(9.0f, 11.0f, 11.0f, 13.5f).texture("#all");
                        break;
                    }
                    case UP: {
                        builder.uvs(9.0f, 9.0f, 11.0f, 11.0f).texture("#all");
                        break;
                    }
                    case DOWN: {
                        builder.uvs(9.0f, 13.5f, 11.0f, 15.5f).texture("#all");
                    }
                }
            }).end();
        }
        if (eggs >= 3) {
            model.element().from(4.0f, 0.0f, 9.0f).to(7.0f, 4.0f, 12.0f).allFaces((face, builder) -> {
                switch (face) {
                    case NORTH: {
                        builder.uvs(11.5f, 0.0f, 13.0f, 2.0f).texture("#all");
                        break;
                    }
                    case EAST: {
                        builder.uvs(10.0f, 0.0f, 11.5f, 2.0f).texture("#all");
                        break;
                    }
                    case SOUTH: {
                        builder.uvs(8.5f, 0.0f, 10.0f, 2.0f).texture("#all");
                        break;
                    }
                    case WEST: {
                        builder.uvs(7.0f, 0.0f, 8.5f, 2.0f).texture("#all");
                        break;
                    }
                    case UP: {
                        builder.uvs(12.5f, 4.5f, 14.0f, 6.0f).texture("#all");
                        break;
                    }
                    case DOWN: {
                        builder.uvs(12.5f, 2.5f, 14.0f, 4.0f).texture("#all");
                    }
                }
            }).end();
        }
        if (eggs >= 4) {
            model.element().from(11.0f, 0.0f, 8.0f).to(15.0f, 6.0f, 12.0f).allFaces((face, builder) -> {
                switch (face) {
                    case NORTH: {
                        builder.uvs(7.0f, 11.0f, 9.0f, 13.5f).texture("#all");
                        break;
                    }
                    case EAST: {
                        builder.uvs(5.0f, 11.0f, 7.0f, 13.5f).texture("#all");
                        break;
                    }
                    case SOUTH: {
                        builder.uvs(11.0f, 11.0f, 13.0f, 13.5f).texture("#all");
                        break;
                    }
                    case WEST: {
                        builder.uvs(9.0f, 11.0f, 11.0f, 13.5f).texture("#all");
                        break;
                    }
                    case UP: {
                        builder.uvs(9.0f, 9.0f, 11.0f, 11.0f).texture("#all");
                        break;
                    }
                    case DOWN: {
                        builder.uvs(9.0f, 13.5f, 11.0f, 15.5f).texture("#all");
                    }
                }
            }).end();
        }
        return model;
    }
}

