/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.data.advancement;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.advancement.GeodeHitBlockTrigger;
import com.crypticmushroom.minecraft.midnight.common.advancement.ItemProjectileThrowTrigger;
import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.advancement.ReceiveBowTrigger;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.NightstagEntity;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBiomeTags;
import com.crypticmushroom.minecraft.registry.data.provider.advancement.CrypticAdvancementProvider;
import com.crypticmushroom.minecraft.registry.data.registry.TagRegistry;
import com.crypticmushroom.minecraft.registry.directory.RegistryDirectory;
import com.crypticmushroom.minecraft.registry.directory.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityHurtPlayerTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public final class MnAdvancements
implements ForgeAdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement storyRoot = MnAdvancements.builder().display(MnBlocks.NIGHT_GRASS_BLOCK, "advancements.midnight.story.root.title", "The Midnight", "advancements.midnight.story.root.description", "You might want to bring a torch.", Midnight.id("textures/block/nightstone.png"), FrameType.TASK, false, false, false).addCriterion("crafting_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50091_})).m_138389_(saver, Midnight.idStr("story/root"));
        Advancement useCorruptedPearl = MnAdvancements.builder().parent(storyRoot).display(MnItems.CORRUPTED_PEARL, "advancements.midnight.story.use_corrupted_pearl.title", "Malign Magnetism", "advancements.midnight.story.use_corrupted_pearl.description", "Use the Corrupted Pearl of a Nightshade to locate a Rift", null, FrameType.GOAL, true, true, false).addCriterion("use_corrupted_pearl", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(MnCriteriaTriggers.USE_CORRUPTED_PEARL.m_7295_(), ContextAwarePredicate.f_285567_)).m_138389_(saver, Midnight.idStr("story/use_corrupted_pearl"));
        Advancement encounterRifter = MnAdvancements.builder().parent(storyRoot).display(MnBlocks.MALIGNANT_PLANT_BLOCK, "advancements.midnight.story.encounter_rifter.title", "An Otherworldly Encounter", "advancements.midnight.story.encounter_rifter.description", "Encounter a mysterious creature from a Rift", null, FrameType.TASK, true, true, false).requirements(RequirementsStrategy.f_15979_).addCriterion("hurt_by_rifter", (CriterionTriggerInstance)EntityHurtPlayerTrigger.TriggerInstance.m_35206_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)MnEntityTypes.RIFTER.get()))))).addCriterion("attack_rifter", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)MnEntityTypes.RIFTER.get()))))).m_138389_(saver, Midnight.idStr("story/hurt_by_rifter"));
        Advancement enterMidnight = MnAdvancements.builder().parent(encounterRifter).display(MnBlocks.NIGHT_GRASS_BLOCK, "advancements.midnight.story.enter_midnight.title", "Lights Out", "advancements.midnight.story.enter_midnight.description", "Travel to the Midnight by entering a rift", Midnight.id("textures/block/nightstone.png"), FrameType.TASK, true, true, false).addCriterion("entered_the_midnight", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(MnDimensions.THE_MIDNIGHT.get())).m_138389_(saver, Midnight.idStr("story/enter_midnight"));
        CrypticAdvancementProvider.AdvancementBuilder visitUndergroundBiomeBuilder = MnAdvancements.builder().parent(enterMidnight).display(MnBlocks.NIGHTSTONE, "advancements.midnight.visit_underground_biome.title", "Nyctophobia Denier", "advancements.midnight.visit_underground_biome.description", "Descend into an underground biome in the Midnight", null, FrameType.TASK, true, true, false).requirements(RequirementsStrategy.f_15979_);
        MnRegistry.BIOMES.getResources().stream().sorted().filter(biome -> TagRegistry.get((RegistryInfo)RegistryDirectory.BIOME).tagContains("midnight", MnBiomeTags.IS_UNDERGROUND, biome, true)).forEach(biome -> visitUndergroundBiomeBuilder.addCriterion("entered_" + biome.m_135782_().m_135815_(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_((ResourceKey)biome))));
        Advancement visitUndergroundBiome = visitUndergroundBiomeBuilder.m_138389_(saver, Midnight.idStr("adventure/visit_underground_biome"));
        Advancement breakStingerEggs = MnAdvancements.builder().parent(visitUndergroundBiome).display(MnItems.STINGER_EGG, "advancements.midnight.story.break_stinger_eggs.title", "Cracked Up", "advancements.midnight.story.break_stinger_eggs.description", "Accidentally (or purposefully) break a Stinger Egg", null, FrameType.TASK, true, true, false).addCriterion("break_eggs", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(MnCriteriaTriggers.BREAK_EGGS.m_7295_(), ContextAwarePredicate.f_285567_)).m_138389_(saver, Midnight.idStr("story/break_stinger_eggs"));
        CrypticAdvancementProvider.AdvancementBuilder visitEvilBiomeBuilder = MnAdvancements.builder().parent(enterMidnight).display(MnBlocks.MALIGNANT_PLANT_BLOCK, "advancements.midnight.visit_corrupted_biome.title", "Wanderer of Malevolence", "advancements.midnight.visit_corrupted_biome.description", "Discover one of the most corrupted biomes in the Midnight", null, FrameType.TASK, true, true, false).requirements(RequirementsStrategy.f_15979_);
        MnRegistry.BIOMES.getResources().stream().sorted().filter(biome -> TagRegistry.get((RegistryInfo)RegistryDirectory.BIOME).tagContains("midnight", MnBiomeTags.IS_EVIL, biome, true)).forEach(biome -> visitEvilBiomeBuilder.addCriterion("entered_" + biome.m_135782_().m_135815_(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_((ResourceKey)biome))));
        Advancement visitEvilBiome = visitEvilBiomeBuilder.m_138389_(saver, Midnight.idStr("adventure/visit_corrupted_biome"));
        CrypticAdvancementProvider.AdvancementBuilder visitAllBiomesBuilder = MnAdvancements.builder().parent(visitEvilBiome).display(MnItems.TENEBRUM_BOOTS, "advancements.midnight.visit_every_biome.title", "Nightwalker", "advancements.midnight.visit_every_biome.description", "Traverse every single biome in the Midnight", null, FrameType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.m_10005_((int)100)).requirements(RequirementsStrategy.f_15978_);
        MnRegistry.BIOMES.getResources().stream().sorted().forEach(biome -> visitAllBiomesBuilder.addCriterion("entered_" + biome.m_135782_().m_135815_(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_((ResourceKey)biome))));
        Advancement visitAllBiomes = visitAllBiomesBuilder.m_138389_(saver, Midnight.idStr("adventure/visit_every_biome"));
        Advancement obtainRockshroom = MnAdvancements.builder().parent(enterMidnight).display(MnItems.ROCKSHROOM_CLUMP, "advancements.midnight.story.obtain_rockshroom.title", "A Sturdy Shroom", "advancements.midnight.story.obtain_rockshroom.description", "Mine some Rockshroom Clumps from a heap", null, FrameType.TASK, true, true, false).addCriterion("rockshroom", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_CLUMP.get()})).m_138389_(saver, Midnight.idStr("story/obtain_rockshroom"));
        Advancement deflectUsingRockshroomShield = MnAdvancements.builder().parent(obtainRockshroom).display(MnItems.ROCKSHROOM_SHIELD, "advancements.midnight.story.deflect_with_rockshroom_shield.title", "No Hard Feelings", "advancements.midnight.story.deflect_with_rockshroom_shield.description", "Deflect a projectile with a Rockshroom Shield", null, FrameType.TASK, true, true, false).addCriterion("deflect_projectile", (CriterionTriggerInstance)EntityHurtPlayerTrigger.TriggerInstance.m_35206_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_269507_(TagPredicate.m_269314_((TagKey)DamageTypeTags.f_268524_))).m_24934_(Boolean.valueOf(true)))).m_138389_(saver, Midnight.idStr("story/deflect_with_rockshroom_shield"));
        Advancement obtainRockshroomArmour = MnAdvancements.builder().parent(obtainRockshroom).display(MnItems.ROCKSHROOM_CHESTPLATE, "advancements.midnight.story.obtain_rockshroom_armour.title", "Rock Solid", "advancements.midnight.story.obtain_rockshroom_armour.description", "Get some Rockshroom Armour", null, FrameType.TASK, true, true, false).requirements(RequirementsStrategy.f_15979_).addCriterion("rockshroom_helmet", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_HELMET.get()})).addCriterion("rockshroom_chestplate", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_CHESTPLATE.get()})).addCriterion("rockshroom_leggings", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_LEGGINGS.get()})).addCriterion("rockshroom_boots", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.ROCKSHROOM_BOOTS.get()})).m_138389_(saver, Midnight.idStr("story/obtain_rockshroom_armour"));
        Advancement obtainEbonite = MnAdvancements.builder().parent(visitUndergroundBiome).display(MnItems.EBONITE, "advancements.midnight.story.obtain_ebonite.title", "Iron Plus Plus", "advancements.midnight.story.obtain_ebonite.description", "Mine some raw Ebonite", null, FrameType.TASK, true, true, false).addCriterion("ebonite", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.EBONITE.get()})).m_138389_(saver, Midnight.idStr("story/obtain_ebonite"));
        Advancement attackWithEboniteSword = MnAdvancements.builder().parent(obtainEbonite).display(MnItems.EBONITE_SWORD, "advancements.midnight.story.attack_with_ebonite_sword.title", "Ebony Warrior", "advancements.midnight.story.attack_with_ebonite_sword.description", "Attack something using an Ebonite Sword", null, FrameType.TASK, true, true, false).addCriterion("attack_with_ebonite_sword", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)MnItems.EBONITE_SWORD.get()}).m_45077_()).m_32207_()))))).m_138389_(saver, Midnight.idStr("story/attack_using_ebonite_sword"));
        Advancement obtainEbonitePickaxe = MnAdvancements.builder().parent(obtainEbonite).display(MnItems.EBONITE_PICKAXE, "advancements.midnight.story.obtain_ebonite_pickaxe.title", "Ebony Excavator", "advancements.midnight.story.obtain_ebonite_pickaxe.description", "Craft a shiny... wait, dull, new pickaxe", null, FrameType.TASK, true, true, false).addCriterion("ebonite_pickaxe", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.EBONITE_PICKAXE.get()})).m_138389_(saver, Midnight.idStr("story/obtain_ebonite_pickaxe"));
        Advancement obtainNagriliteIngot = MnAdvancements.builder().parent(obtainEbonitePickaxe).display(MnItems.NAGRILITE_INGOT, "advancements.midnight.story.obtain_nagrilite_ingot.title", "Hidden in the Shadows", "advancements.midnight.story.obtain_nagrilite_ingot.description", "Smelt a Nagrilite Ingot", null, FrameType.TASK, true, true, false).addCriterion("nagrilite_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.NAGRILITE_INGOT.get()})).m_138389_(saver, Midnight.idStr("story/obtain_nagrilite_ingot"));
        Advancement throwBladeloop = MnAdvancements.builder().parent(obtainNagriliteIngot).display(MnItems.NAGRILITE_BLADELOOP, "advancements.midnight.story.throw_bladeloop.title", "You Spin me Right Round", "advancements.midnight.story.throw_bladeloop.description", "Throw a Bladeloop at something", null, FrameType.TASK, true, true, false).addCriterion("hit_entity_with_bladeloop", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_60149_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_269507_(TagPredicate.m_269314_((TagKey)DamageTypeTags.f_268524_)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)MnEntityTypes.NAGRILITE_BLADELOOP.get()))))).m_138389_(saver, Midnight.idStr("story/throw_bladeloop"));
        Advancement obtainTenebrumIngot = MnAdvancements.builder().parent(obtainEbonitePickaxe).display(MnItems.TENEBRUM_INGOT, "advancements.midnight.story.obtain_tenebrum_ingot.title", "Heavy Metal", "advancements.midnight.story.obtain_tenebrum_ingot.description", "Smelt a Tenebrum Ingot", null, FrameType.TASK, true, true, false).addCriterion("tenebrum_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.TENEBRUM_INGOT.get()})).m_138389_(saver, Midnight.idStr("story/obtain_tenebrum_ingot"));
        Advancement obtainTenebrumShield = MnAdvancements.builder().parent(obtainTenebrumIngot).display(MnItems.TENEBRUM_SHIELD, "advancements.midnight.story.obtain_tenebrum_shield.title", "Heavyweight", "advancements.midnight.story.obtain_tenebrum_shield.description", "Craft a Tenebrum Shield", null, FrameType.TASK, true, true, false).addCriterion("tenebrum_shield", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.TENEBRUM_SHIELD.get()})).m_138389_(saver, Midnight.idStr("story/obtain_tenebrum_shield"));
        Advancement obtainTenebrumArmour = MnAdvancements.builder().parent(obtainTenebrumIngot).display(MnItems.TENEBRUM_CHESTPLATE, "advancements.midnight.story.obtain_tenebrum_armour.title", "Absolute Unit", "advancements.midnight.story.obtain_tenebrum.description", "Get a full suit of Tenebrum Armour", null, FrameType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.m_10005_((int)100)).addCriterion("tenebrum_helmet", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnItems.TENEBRUM_HELMET.get(), (ItemLike)MnItems.TENEBRUM_CHESTPLATE.get(), (ItemLike)MnItems.TENEBRUM_LEGGINGS.get(), (ItemLike)MnItems.TENEBRUM_BOOTS.get()})).m_138389_(saver, Midnight.idStr("story/obtain_tenebrum_armour"));
        Advancement obtainTenebrumSmithingTable = MnAdvancements.builder().parent(obtainTenebrumIngot).display(MnBlocks.TENEBRUM_SMITHING_TABLE, "advancements.midnight.story.obtain_tenebrum_smithing_table.title", "Heavy Duty", "advancements.midnight.story.obtain_tenebrum_smithing_table.description", "Craft a Tenebrum Smithing Table and smith an item with it", null, FrameType.TASK, true, true, false).addCriterion("get_tenebrum_smithing_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)MnBlocks.TENEBRUM_SMITHING_TABLE.get()})).m_138389_(saver, Midnight.idStr("story/get_tenebrum_smithing_table"));
        Advancement breakGeode = MnAdvancements.builder().parent(visitUndergroundBiome).display(MnItems.GEODE, "advancements.midnight.story.break_geode.title", "A Smashing Success", "advancements.midnight.story.break_geode.description", "Break open a Geode by throwing it at something tough", null, FrameType.TASK, true, true, false).addCriterion("break_geode", (CriterionTriggerInstance)GeodeHitBlockTrigger.Instance.withBreakOnly(true)).m_138389_(saver, Midnight.idStr("story/break_geode"));
        Advancement throwBladeshroom = MnAdvancements.builder().parent(enterMidnight).display(MnItems.BLADESHROOM_CAP, "advancements.midnight.story.throw_bladeshroom.title", "Shroomikens", "advancements.midnight.story.throw_bladeshroom.description", "Throw a Bladeshroom Cap", null, FrameType.TASK, true, true, false).addCriterion("throw_bladeshroom", (CriterionTriggerInstance)ItemProjectileThrowTrigger.Instance.withItem((ItemLike)MnItems.BLADESHROOM_CAP.get())).m_138389_(saver, Midnight.idStr("story/throw_bladeshroom"));
        Advancement destroySuavis = MnAdvancements.builder().parent(enterMidnight).display(MnBlocks.SUAVIS, "advancements.midnight.story.destroy_suavis.title", "Inebriated", "advancements.midnight.story.destroy_suavis.description", "Destroy a Suavis", null, FrameType.TASK, true, true, false).addCriterion("destroy_suavis", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(MnCriteriaTriggers.DESTROY_SUAVIS.m_7295_(), ContextAwarePredicate.f_285567_)).m_138389_(saver, Midnight.idStr("story/destroy_suavis"));
        Advancement violeafCureNausea = MnAdvancements.builder().parent(destroySuavis).display(MnBlocks.VIOLEAF, "advancements.midnight.story.violeaf_cure_nausea.title", "Herbal Remedy", "advancements.midnight.story.violeaf_cure_nausea.description", "Use a Violeaf to cure yourself of Nausea", null, FrameType.TASK, true, true, false).addCriterion("violeaf_cure_nausea", (CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(MnCriteriaTriggers.VIOLEAF_CURE_NAUSEA.m_7295_(), ContextAwarePredicate.f_285567_)).m_138389_(saver, Midnight.idStr("story/violeaf_cure_nausea"));
        CrypticAdvancementProvider.AdvancementBuilder anyNightStagBowBuilder = MnAdvancements.builder().parent(enterMidnight).display(MnItems.NIGHTSTAG_SPAWN_EGG, "advancements.midnight.husbandry.any_nightstag_bow.title", "Your Excellency", "advancements.midnight.husbandry.any_nightstag_bow.description", "Have a Nightstag bow down to you", null, FrameType.TASK, true, true, false).requirements(RequirementsStrategy.f_15979_);
        for (NightstagEntity.AntlerType type : NightstagEntity.AntlerType.values()) {
            anyNightStagBowBuilder.addCriterion("receive_bow_from_" + type.ordinal(), (CriterionTriggerInstance)ReceiveBowTrigger.Instance.withType(type));
        }
        Advancement anyNightStagBow = anyNightStagBowBuilder.m_138389_(saver, Midnight.idStr("husbandry/any_nightstag_bow"));
        CrypticAdvancementProvider.AdvancementBuilder everyNightstagBowBuilder = MnAdvancements.builder().parent(anyNightStagBow).display(MnItems.NIGHTSTAG_SPAWN_EGG, "advancements.midnight.husbandry.every_nightstag_bow.title", "Your Highness", "advancements.midnight.husbandry.every_nightstag_bow.description", "Have every color of Nightstag bow down to you", null, FrameType.CHALLENGE, true, true, false).requirements(RequirementsStrategy.f_15978_);
        for (NightstagEntity.AntlerType type : NightstagEntity.AntlerType.values()) {
            everyNightstagBowBuilder.addCriterion("receive_bow_from_" + type.ordinal(), (CriterionTriggerInstance)ReceiveBowTrigger.Instance.withType(type));
        }
        Advancement everyNightStagBow = everyNightstagBowBuilder.m_138389_(saver, Midnight.idStr("husbandry/every_nightstag_bow"));
    }

    private static CrypticAdvancementProvider.AdvancementBuilder builder() {
        return new CrypticAdvancementProvider.AdvancementBuilder("midnight");
    }
}

