/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.data;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.misc.MnLootParameterSets;
import com.crypticmushroom.minecraft.midnight.coremod.reflection.ReflectionUtil;
import com.crypticmushroom.minecraft.midnight.data.advancement.MnAdvancements;
import com.crypticmushroom.minecraft.midnight.data.loot.GeodeLootTables;
import com.crypticmushroom.minecraft.midnight.data.loot.MnBlockLootTables;
import com.crypticmushroom.minecraft.midnight.data.loot.MnChestLootTables;
import com.crypticmushroom.minecraft.midnight.data.loot.MnEntityLootTables;
import com.crypticmushroom.minecraft.midnight.data.provider.atlas.MnSpriteSourceProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.compatibility.lucent.MnBlockTextureLightingProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.compatibility.lucent.MnEntityLightingProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.compatibility.lucent.MnItemLightingProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.model.MnBlockStateProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.model.MnItemModelProvider;
import com.crypticmushroom.minecraft.midnight.data.provider.recipe.MnRecipeProvider;
import com.crypticmushroom.minecraft.registry.CrypticRegistry;
import com.crypticmushroom.minecraft.registry.data.provider.advancement.CrypticAdvancementProvider;
import com.crypticmushroom.minecraft.registry.data.provider.builtin.CrypticDatapackBuiltinEntriesProvider;
import com.crypticmushroom.minecraft.registry.data.provider.lang.CrypticLanguageProvider;
import com.crypticmushroom.minecraft.registry.data.provider.loot.CrypticLootTableProvider;
import com.crypticmushroom.minecraft.registry.data.provider.metadata.CrypticPackMetadataGenerator;
import com.crypticmushroom.minecraft.registry.data.provider.particle.CrypticParticleDescriptionProvider;
import com.crypticmushroom.minecraft.registry.data.provider.sound.CrypticSoundsDefinitionsProvider;
import com.google.common.reflect.Reflection;
import java.util.List;
import java.util.Set;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MidnightDataGen
extends MidnightClient {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Client/DATAGEN").addParents(new Marker[]{MidnightClient.MARKER});

    @Override
    public void addEventListeners(IEventBus modBus) {
        super.addEventListeners(modBus);
        modBus.addListener(MidnightDataGen::gatherData);
    }

    private static void gatherData(GatherDataEvent event) {
        String modId = "midnight";
        new MnBlockStateProvider(event).addToGenerator();
        new MnItemModelProvider(event).addToGenerator();
        new MnRecipeProvider(event).addToGenerator();
        new CrypticLootTableProvider("midnight", event, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MnBlockLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(MnChestLootTables::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(GeodeLootTables::new, MnLootParameterSets.GEODE), new LootTableProvider.SubProviderEntry(MnEntityLootTables::new, LootContextParamSets.f_81415_))).addToGenerator();
        new CrypticAdvancementProvider("midnight", event, new ForgeAdvancementProvider.AdvancementGenerator[]{new MnAdvancements()}).addToGenerator();
        new CrypticSoundsDefinitionsProvider("midnight", event).addToGenerator();
        new CrypticParticleDescriptionProvider("midnight", event).addToGenerator();
        CrypticDatapackBuiltinEntriesProvider registries = new CrypticDatapackBuiltinEntriesProvider("midnight", event);
        registries.addToGenerator();
        CrypticRegistry.addAllTagProviders((String)"midnight", (GatherDataEvent)event, (RegistriesDatapackGenerator)registries);
        new MnSpriteSourceProvider(event).addToGenerator();
        new MnItemLightingProvider(event).addToGenerator();
        new MnEntityLightingProvider(event).addToGenerator();
        new MnBlockTextureLightingProvider(event).addToGenerator();
        new CrypticPackMetadataGenerator("midnight", event).addToGenerator();
        new CrypticLanguageProvider("midnight", event, "en_us"){
            {
                List<String> packages = List.of("com.crypticmushroom.minecraft.midnight.common.compatibility.jade");
                List<Class<Rift>> classes = List.of(Rift.class);
                packages.forEach(ReflectionUtil::initPackage);
                classes.forEach(xva$0 -> Reflection.initialize((Class[])new Class[]{xva$0}));
            }
        }.addToGenerator();
    }

    public static MidnightDataGen get() {
        try {
            return (MidnightDataGen)Midnight.get();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Cannot get the datagen client instance of the Midnight when not on its datagen!", e);
        }
    }
}

