/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.coremod.reflection;

import com.crypticmushroom.minecraft.midnight.coremod.MidnightCoreMod;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import cpw.mods.modlauncher.api.INameMappingService;
import java.io.IOException;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class ReflectionUtil {
    public static void initPackage(String packageName) {
        try {
            ImmutableSet classes = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses(packageName);
            classes.forEach(c -> {
                MidnightCoreMod.LOGGER.debug(MidnightCoreMod.MARKER_REFLECTION, "Initializing {} via reflection", c);
                try {
                    Class.forName(c.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to initialize class %s".formatted(c.getName()), e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean threadContains(Class<?> clazz, String methodName) {
        return ReflectionUtil.threadContains(Thread.currentThread().getStackTrace(), clazz.getName(), methodName);
    }

    public static boolean threadContains(Thread thread, Class<?> clazz, String methodName) {
        return ReflectionUtil.threadContains(thread.getStackTrace(), clazz.getName(), methodName);
    }

    public static boolean threadContains(StackTraceElement[] elements, Class<?> clazz, String methodName) {
        return ReflectionUtil.threadContains(elements, clazz.getName(), methodName);
    }

    public static boolean threadContains(String className, String methodName) {
        return ReflectionUtil.threadContains(Thread.currentThread().getStackTrace(), className, methodName);
    }

    public static boolean threadContains(Thread thread, String className, String methodName) {
        return ReflectionUtil.threadContains(thread.getStackTrace(), className, methodName);
    }

    public static boolean threadContains(StackTraceElement[] elements, String className, String methodName) {
        methodName = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)methodName);
        for (StackTraceElement element : elements) {
            boolean clazz = element.getClassName().equals(className);
            boolean method = element.getMethodName().equals(methodName);
            if (!clazz || !method) continue;
            return true;
        }
        return false;
    }
}

