/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.coremod.mixin;

import com.crypticmushroom.minecraft.midnight.common.entity.IMnPreventsSleep;
import com.crypticmushroom.minecraft.midnight.common.world.dimension.IMnTeleporter;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Inject(method={"startSleepInBed(Lnet/minecraft/core/BlockPos;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="INVOKE", target="net/minecraft/world/level/Level.getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;")}, cancellable=true)
    private void checkSleepPrevention(BlockPos pAt, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> callback, @Local(index=5) double xRadius, @Local(index=7) double yRadius, @Local(index=9) Vec3 origin) {
        Pair pair = ((ServerPlayer)this).m_9236_().m_45933_(null, new AABB(origin.m_7096_() - xRadius, origin.m_7098_() - yRadius, origin.m_7094_() - xRadius, origin.m_7096_() + xRadius, origin.m_7098_() + yRadius, origin.m_7094_() + xRadius)).stream().filter(e -> {
            IMnPreventsSleep mnE;
            return e instanceof IMnPreventsSleep && (mnE = (IMnPreventsSleep)e).getSleepPreventReason((ServerPlayer)this) != null;
        }).map(e -> ((IMnPreventsSleep)e).getSleepPreventReason((ServerPlayer)this)).findFirst().orElse(null);
        if (pair == null) {
            return;
        }
        if (((Player.BedSleepingProblem)pair.getFirst()).m_36423_() == null) {
            ((ServerPlayer)this).m_5661_(Objects.requireNonNull((Component)pair.getSecond(), "Check your IMnPreventsSleep implementation! For a bed sleeping problem with no message, a custom message must be supplied!"), true);
        }
        callback.setReturnValue((Object)Either.left((Object)((Player.BedSleepingProblem)pair.getFirst())));
    }

    @Inject(method={"changeDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraftforge/common/util/ITeleporter;)Lnet/minecraft/world/entity/Entity;"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void checkTeleporter(ServerLevel destination, ITeleporter teleporter, CallbackInfoReturnable<@Nullable Entity> callback) {
        IMnTeleporter mnTeleporter;
        if (teleporter instanceof IMnTeleporter && !(mnTeleporter = (IMnTeleporter)teleporter).canTeleport((Entity)((ServerPlayer)this), (ResourceKey<Level>)destination.m_46472_())) {
            callback.setReturnValue(null);
        }
    }
}

