/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.manager;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftAttachment;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftBridge;
import com.crypticmushroom.minecraft.midnight.common.network.level.RiftBridgeMessage;
import com.crypticmushroom.minecraft.midnight.coremod.reflection.ReflectionUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RiftBridgeManager {
    public static RiftBridgeManager get(LevelReader level) {
        return RiftBridgeManager.get(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    public static RiftBridgeManager get(LogicalSide side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalSide.CLIENT -> Client.get();
            case LogicalSide.SERVER -> Server.get();
        };
    }

    public void update();

    public RiftBridge create(RiftAttachment var1) throws UnsupportedOperationException;

    public void add(RiftBridge var1);

    public void remove(int var1);

    @Nullable
    public RiftBridge get(int var1);

    public static final class Client
    implements RiftBridgeManager {
        private final Int2ObjectMap<RiftBridge> bridges = new Int2ObjectOpenHashMap();

        @Deprecated
        public static Client get() {
            return MidnightClient.get().getBridgeManager();
        }

        public Client() {
            if (!ReflectionUtil.threadContains(MidnightClient.class, "onClientPlayerLoggingIn")) {
                throw new IllegalCallerException("The client-side rift bridge manager can only be instantiated by MidnightClient");
            }
        }

        @Override
        public void update() {
            this.bridges.values().forEach(RiftBridge::tickTimers);
        }

        @Override
        @Deprecated
        public RiftBridge create(RiftAttachment attachment) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot create a bridge for the client bridge manager");
        }

        @Override
        public void add(RiftBridge bridge) {
            this.bridges.put(bridge.getId(), (Object)bridge);
        }

        @Override
        public void remove(int id) {
            RiftBridge bridge = (RiftBridge)this.bridges.remove(id);
            if (bridge != null) {
                bridge.remove();
            }
        }

        @Override
        @Nullable
        public RiftBridge get(int id) {
            return (RiftBridge)this.bridges.get(id);
        }
    }

    public static final class Server
    extends SavedData
    implements RiftBridgeManager {
        public static final String KEY = Midnight.idStr("bridge_manager");
        private final Int2ObjectMap<RiftBridge> bridges = new Int2ObjectOpenHashMap();
        private int currentId;

        public static Server get() {
            DimensionDataStorage storage = Midnight.getMinecraftServer().m_129783_().m_8895_();
            return (Server)storage.m_164861_(Server::load, Server::new, KEY);
        }

        private Server() {
        }

        private static Server load(CompoundTag compound) {
            Server manager = new Server();
            manager.currentId = compound.m_128451_("current_id");
            ListTag bridgeList = compound.m_128437_("bridges", 10);
            for (int i = 0; i < bridgeList.size(); ++i) {
                CompoundTag bridgeNbt = bridgeList.m_128728_(i);
                RiftBridge bridge = RiftBridge.deserialize(bridgeNbt);
                manager.bridges.put(bridge.getId(), (Object)bridge);
            }
            return manager;
        }

        @Override
        public void update() {
            ObjectIterator iterator = this.bridges.values().iterator();
            while (iterator.hasNext()) {
                RiftBridge bridge = (RiftBridge)iterator.next();
                bridge.tickTimers();
                if (!bridge.tickState()) continue;
                bridge.exists = false;
                this.notifyRemoval(bridge);
                iterator.remove();
            }
        }

        @Override
        public RiftBridge create(RiftAttachment attachment) {
            return new RiftBridge(this.currentId++, attachment);
        }

        @Override
        public void add(RiftBridge bridge) {
            this.bridges.put(bridge.getId(), (Object)bridge);
            this.m_77762_();
        }

        @Override
        public void remove(int id) {
            RiftBridge bridge = (RiftBridge)this.bridges.remove(id);
            if (bridge != null) {
                this.notifyRemoval(bridge);
            }
        }

        private void notifyRemoval(RiftBridge bridge) {
            bridge.exists = false;
            bridge.getTracker().sendToTracking(new RiftBridgeMessage.Remove(bridge));
            this.m_77762_();
        }

        @Override
        @Nullable
        public RiftBridge get(int id) {
            return (RiftBridge)this.bridges.get(id);
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            compound.m_128405_("current_id", this.currentId);
            ListTag bridgeList = new ListTag();
            for (RiftBridge bridge : this.bridges.values()) {
                bridgeList.add((Object)bridge.serialize(new CompoundTag()));
            }
            compound.m_128365_("bridges", (Tag)bridgeList);
            return compound;
        }
    }
}

