/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.structure.structure;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class MidnightJigsawStructure
extends Structure {
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final boolean buildColumnsDownwards;
    public static final Codec<MidnightJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MidnightJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("size").forGetter(structure -> structure.size), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.fieldOf("build_columns_downwards").forGetter(structure -> structure.buildColumnsDownwards)).apply((Applicative)instance, MidnightJigsawStructure::new)).codec();

    protected MidnightJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, Optional<Heightmap.Types> projectStartToHeightmap, HeightProvider startHeight, int maxDistanceFromCenter, boolean buildColumnsDownwards) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.buildColumnsDownwards = buildColumnsDownwards;
    }

    private boolean extraSpawningChecks(Structure.GenerationContext context) {
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
        if (!this.extraSpawningChecks(ctx)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)ctx.f_226626_(), new WorldGenerationContext(ctx.f_226622_(), ctx.f_226629_()));
        ChunkPos chunkPos = ctx.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)ctx, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)MnStructureTypes.GENERIC_STRUCTURE.get();
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        if (this.buildColumnsDownwards) {
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            BoundingBox bb = piecesContainer.m_192756_();
            int structureBottomY = bb.m_162396_();
            int minBuildHeight = level.m_141937_();
            for (int x = bb.m_162395_(); x <= bb.m_162399_(); ++x) {
                block1: for (int z = bb.m_162398_(); z <= bb.m_162401_(); ++z) {
                    if (chunkPos.f_45578_ != x >> 4 || chunkPos.f_45579_ != z >> 4) continue;
                    mPos.m_122178_(x, structureBottomY, z);
                    if (level.m_46859_((BlockPos)mPos) || !bb.m_71051_((Vec3i)mPos) || !piecesContainer.m_192751_((BlockPos)mPos)) continue;
                    BlockState bottomBlock = level.m_8055_((BlockPos)mPos);
                    for (int currentY = structureBottomY - 1; currentY > minBuildHeight; --currentY) {
                        mPos.m_142448_(currentY);
                        if (!level.m_46859_((BlockPos)mPos) && !level.m_8055_((BlockPos)mPos).m_278721_()) continue block1;
                        level.m_7731_((BlockPos)mPos, bottomBlock, 2);
                    }
                }
            }
        }
    }
}

