/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.processor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StateProviderReplacementProcessor
extends StructureProcessor {
    public static final Codec<StateProviderReplacementProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("input_state").forGetter(processor -> processor.inputState), (App)BlockStateProvider.f_68747_.fieldOf("scale").forGetter(processor -> processor.outputStates)).apply((Applicative)instance, StateProviderReplacementProcessor::new));
    private final BlockState inputState;
    private final BlockStateProvider outputStates;

    public StateProviderReplacementProcessor(BlockState stateToReplace, BlockStateProvider stateProvider) {
        this.inputState = stateToReplace;
        this.outputStates = stateProvider;
    }

    public StateProviderReplacementProcessor(Block blockToReplace, BlockStateProvider stateProvider) {
        this(blockToReplace.m_49966_(), stateProvider);
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos posA, BlockPos posB, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoWorld, StructurePlaceSettings settings, StructureTemplate template) {
        XoroshiroRandomSource rand = new XoroshiroRandomSource(Mth.m_14057_((Vec3i)blockInfoWorld.f_74675_()));
        if (blockInfoWorld.f_74676_() == this.inputState) {
            BlockState outputState = this.outputStates.m_213972_((RandomSource)rand, blockInfoLocal.f_74675_());
            return new StructureTemplate.StructureBlockInfo(blockInfoWorld.f_74675_(), outputState, blockInfoWorld.f_74677_());
        }
        return blockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)MnStructureProcessorTypes.STATE_PROVIDER_REPLACEMENT_PROCESSOR.get();
    }
}

