/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.processor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseProcessor
extends StructureProcessor {
    public static final Codec<NoiseProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("threshold").forGetter(processor -> processor.threshold), (App)NormalNoise.NoiseParameters.f_192851_.fieldOf("noise_parameters").forGetter(processor -> processor.parameters), (App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(processor -> processor.stateProvider)).apply((Applicative)instance, NoiseProcessor::new));
    private final double threshold;
    private final NormalNoise.NoiseParameters parameters;
    private final BlockStateProvider stateProvider;

    public NoiseProcessor(double threshold, NormalNoise.NoiseParameters noiseParameters, BlockStateProvider stateProvider) {
        this.threshold = threshold;
        this.parameters = noiseParameters;
        this.stateProvider = stateProvider;
    }

    public NoiseProcessor(double threshold, NormalNoise.NoiseParameters noiseParameters) {
        this(threshold, noiseParameters, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_));
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos posA, BlockPos posB, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoWorld, StructurePlaceSettings settings, StructureTemplate template) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(Mth.m_14057_((Vec3i)blockInfoWorld.f_74675_())));
        NormalNoise noise = NormalNoise.m_230511_((RandomSource)rand, (NormalNoise.NoiseParameters)this.parameters);
        double noiseValue = noise.m_75380_((double)blockInfoWorld.f_74675_().m_123341_(), (double)blockInfoWorld.f_74675_().m_123342_(), (double)blockInfoWorld.f_74675_().m_123343_()) + 1.0 / (double)blockInfoLocal.f_74675_().m_123342_();
        if (!blockInfoWorld.f_74676_().m_60795_() && noiseValue < this.threshold) {
            return new StructureTemplate.StructureBlockInfo(blockInfoWorld.f_74675_(), Blocks.f_50016_.m_49966_(), blockInfoWorld.f_74677_());
        }
        return blockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)MnStructureProcessorTypes.NOISE_DISINTEGRATE_PROCESSOR.get();
    }
}

