/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.tree.trunkplacer;

import com.crypticmushroom.minecraft.midnight.common.registry.MnTrunkPlacerTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ImprovedFancyTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ImprovedFancyTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> ImprovedFancyTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.BOOL.fieldOf("use_fallback").forGetter(trunkPlacer -> trunkPlacer.useFallback), (App)BlockStateProvider.f_68747_.fieldOf("fallback_state_provider").forGetter(trunkPlacer -> trunkPlacer.fallbackStateProvider))).apply((Applicative)instance, ImprovedFancyTrunkPlacer::new));
    private final BlockStateProvider fallbackStateProvider;
    private final boolean useFallback;

    public ImprovedFancyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, boolean useFallback, BlockStateProvider fallbackStateProvider) {
        super(baseHeight, heightRandA, heightRandB);
        this.useFallback = useFallback;
        this.fallbackStateProvider = fallbackStateProvider;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        int j1;
        int j = freeTreeHeight + 2;
        int k = Mth.m_14107_((double)((double)j * 0.618));
        ImprovedFancyTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        int l = Math.min(1, Mth.m_14107_((double)(1.382 + Math.pow((double)j / 13.0, 2.0))));
        int i1 = pos.m_123342_() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoords(pos.m_6630_(j1), i1));
        for (j1 = j - 5; j1 >= 0; --j1) {
            float f = ImprovedFancyTrunkPlacer.treeShape(j, j1);
            if (f < 0.0f) continue;
            for (int k1 = 0; k1 < l; ++k1) {
                BlockPos blockpos1;
                double d2 = 1.0 * (double)f * ((double)random.m_188501_() + 0.328);
                double d3 = (double)(random.m_188501_() * 2.0f) * Math.PI;
                double d4 = d2 * Math.sin(d3) + 0.5;
                double d5 = d2 * Math.cos(d3) + 0.5;
                BlockPos blockpos = pos.m_7918_(Mth.m_14107_((double)d4), j1 - 1, Mth.m_14107_((double)d5));
                if (!this.makeLimb(level, blockSetter, random, blockpos, blockpos1 = blockpos.m_6630_(5), false, config)) continue;
                int l1 = pos.m_123341_() - blockpos.m_123341_();
                int i2 = pos.m_123343_() - blockpos.m_123343_();
                double d6 = (double)blockpos.m_123342_() - Math.sqrt(l1 * l1 + i2 * i2) * 0.381;
                int j2 = d6 > (double)i1 ? i1 : (int)d6;
                BlockPos blockpos2 = new BlockPos(pos.m_123341_(), j2, pos.m_123343_());
                if (!this.makeLimb(level, blockSetter, random, blockpos2, blockpos, false, config)) continue;
                list.add(new FoliageCoords(blockpos, blockpos2.m_123342_()));
            }
        }
        this.makeLimb(level, blockSetter, random, pos, pos.m_6630_(k), true, config);
        this.makeBranches(level, blockSetter, random, j, pos, list, config);
        ArrayList list1 = Lists.newArrayList();
        for (FoliageCoords fancytrunkplacer$foliagecoords : list) {
            if (!this.trimBranches(j, fancytrunkplacer$foliagecoords.getBranchBase() - pos.m_123342_())) continue;
            list1.add(fancytrunkplacer$foliagecoords.attachment);
        }
        return list1;
    }

    private boolean makeLimb(LevelSimulatedReader p_226108_, BiConsumer<BlockPos, BlockState> p_226109_, RandomSource p_226110_, BlockPos basePos, BlockPos offsetPos, boolean p_226113_, TreeConfiguration p_226114_) {
        if (!p_226113_ && Objects.equals(basePos, offsetPos)) {
            return true;
        }
        BlockPos blockpos = offsetPos.m_7918_(-basePos.m_123341_(), -basePos.m_123342_(), -basePos.m_123343_());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = basePos.m_7918_(Mth.m_14143_((float)(0.5f + (float)j * f)), Mth.m_14143_((float)(0.5f + (float)j * f1)), Mth.m_14143_((float)(0.5f + (float)j * f2)));
            if (p_226113_) {
                this.m_226175_(p_226108_, p_226109_, p_226110_, blockpos1, p_226114_, state -> {
                    Direction.Axis logAxis = this.getLogAxis(basePos, blockpos1);
                    if (state.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                        return (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)logAxis);
                    }
                    return logAxis == Direction.Axis.Y || !this.useFallback ? state : (BlockState)this.fallbackStateProvider.m_213972_(p_226110_, blockpos1).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)logAxis);
                });
                continue;
            }
            if (this.m_226184_(p_226108_, blockpos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos pos) {
        int i = Mth.m_14040_((int)pos.m_123341_());
        int j = Mth.m_14040_((int)pos.m_123342_());
        int k = Mth.m_14040_((int)pos.m_123343_());
        return Math.max(i, Math.max(j, k));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos otherPos) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(otherPos.m_123341_() - pos.m_123341_());
        int k = Math.max(i, j = Math.abs(otherPos.m_123343_() - pos.m_123343_()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }

    private boolean trimBranches(int p_70099_, int p_70100_) {
        return (double)p_70100_ >= (double)p_70099_ * 0.2;
    }

    private void makeBranches(LevelSimulatedReader p_226100_, BiConsumer<BlockPos, BlockState> p_226101_, RandomSource p_226102_, int p_226103_, BlockPos p_226104_, List<FoliageCoords> p_226105_, TreeConfiguration p_226106_) {
        for (FoliageCoords fancytrunkplacer$foliagecoords : p_226105_) {
            int i = fancytrunkplacer$foliagecoords.getBranchBase();
            BlockPos blockpos = new BlockPos(p_226104_.m_123341_(), i, p_226104_.m_123343_());
            if (blockpos.equals((Object)fancytrunkplacer$foliagecoords.attachment.m_161451_()) || !this.trimBranches(p_226103_, i - p_226104_.m_123342_())) continue;
            this.makeLimb(p_226100_, p_226101_, p_226102_, blockpos, fancytrunkplacer$foliagecoords.attachment.m_161451_(), true, p_226106_);
        }
    }

    private static float treeShape(int p_70133_, int p_70134_) {
        if ((float)p_70134_ < (float)p_70133_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_70133_ / 2.0f;
        float f1 = f - (float)p_70134_;
        float f2 = Mth.m_14116_((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)MnTrunkPlacerTypes.IMPROVED_FANCY_TRUNK.get();
    }

    static class FoliageCoords {
        final FoliagePlacer.FoliageAttachment attachment;
        private final int branchBase;

        public FoliageCoords(BlockPos attachmentPos, int branchBase) {
            this.attachment = new FoliagePlacer.FoliageAttachment(attachmentPos, 0, false);
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

