/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.tree;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMnTreeFeature<FC extends FeatureConfiguration>
extends Feature<FC> {
    @Nullable
    protected final Supplier<IPlantable> sapling;

    protected AbstractMnTreeFeature(Codec<FC> codec, Supplier<IPlantable> sapling) {
        super(codec);
        this.sapling = sapling;
    }

    public final boolean m_142674_(FeaturePlaceContext<FC> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), context.m_159778_());
    }

    protected abstract boolean place(WorldGenLevel var1, ChunkGenerator var2, RandomSource var3, BlockPos var4, FC var5);

    @Nullable
    protected IPlantable getSapling() {
        return this.sapling != null ? this.sapling.get() : null;
    }

    protected boolean isSoil(WorldGenLevel world, BlockPos pos) {
        if (this.sapling == null) {
            return this.isDirtOrGrassBlock(world, pos);
        }
        return world.m_7433_(pos, state -> state.canSustainPlant((BlockGetter)world, pos, Direction.UP, this.sapling.get()));
    }

    @Deprecated
    public boolean isDirtOrGrassBlock(WorldGenLevel worldIn, BlockPos pos) {
        return worldIn.m_7433_(pos, state -> AbstractMnTreeFeature.m_159759_((BlockState)state) || worldIn.m_7433_(pos, state2 -> {
            Block block = state2.m_60734_();
            return block == MnBlocks.COARSE_NIGHT_DIRT.get() || block == MnBlocks.NIGHT_DIRT.get() || block == MnBlocks.NIGHT_GRASS_BLOCK.get();
        }));
    }

    @Deprecated
    protected BlockPos findSurfaceBelow(WorldGenLevel world, BlockPos origin, int maxDownwardSearch) {
        BlockState currentState = world.m_8055_(origin);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int i = 0; i <= maxDownwardSearch; ++i) {
            currentPos.m_122173_(Direction.DOWN);
            BlockState nextState = world.m_8055_((BlockPos)currentPos);
            if (nextState == ((Block)MnBlocks.NIGHT_BEDROCK.get()).m_49966_()) {
                return null;
            }
            if (currentState.m_60795_() && nextState.m_60838_((BlockGetter)world, origin)) {
                currentPos.m_122173_(Direction.UP);
                return currentPos.m_7949_();
            }
            currentState = nextState;
        }
        return null;
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double radius) {
        return this.produceBlob(origin, radius, radius);
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double horizontalRadius, double verticalRadius) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        int verticalRadiusCeil = Mth.m_14165_((double)verticalRadius);
        int horizontalRadiusCeil = Mth.m_14165_((double)horizontalRadius);
        BlockPos minPos = origin.m_7918_(-horizontalRadiusCeil, -verticalRadiusCeil, -horizontalRadiusCeil);
        BlockPos maxPos = origin.m_7918_(horizontalRadiusCeil, verticalRadiusCeil, horizontalRadiusCeil);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            double deltaZ;
            double deltaY;
            double deltaX = (double)(pos.m_123341_() - origin.m_123341_()) / horizontalRadius;
            double distanceSquared = deltaX * deltaX + (deltaY = (double)(pos.m_123342_() - origin.m_123342_()) / verticalRadius) * deltaY + (deltaZ = (double)(pos.m_123343_() - origin.m_123343_()) / horizontalRadius) * deltaZ;
            if (!(distanceSquared <= 1.0)) continue;
            positions.add(pos.m_7949_());
        }
        return positions;
    }

    protected boolean canGrowInto(WorldGenLevel world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || Feature.m_159759_((BlockState)state) || !state.m_60838_((BlockGetter)world, pos));
    }

    protected boolean isAirOrLeaves(WorldGenLevel world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }
}

