/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.template;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.TemplateConfig;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.template.BasicTemplateFeature;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.mutable.MutableInt;

public class RuinTemplateFeature
extends BasicTemplateFeature<TemplateConfig> {
    public RuinTemplateFeature() {
        super(TemplateConfig.CODEC);
    }

    @Override
    protected BlockPos adjustPosition(WorldGenLevel level, StructureTemplate template, BlockPos templateZero, BlockPos offset, BlockPos origin, Vec3i size, Rotation rot, TemplateConfig config) {
        int z;
        int y;
        int x = offset.m_123341_();
        BoundingBox bb = new BoundingBox(x, y = offset.m_123342_(), z = offset.m_123343_(), x + size.m_123341_(), y, z + size.m_123343_());
        int emptyCorners = RuinTemplateFeature.countEmptyBottomCorners(level, bb);
        return emptyCorners < 4 ? null : templateZero;
    }

    private static int countEmptyBottomCorners(WorldGenLevel level, BoundingBox bb) {
        MutableInt count = new MutableInt(0);
        RuinTemplateFeature.forBottomCorners(bb, pos -> {
            BlockState state = level.m_8055_(pos);
            BlockState stateAbove = level.m_8055_(pos.m_6630_(2));
            if (!state.m_60795_() && state.m_60819_().m_76178_() && stateAbove.m_60795_()) {
                count.add(1);
            }
        });
        return count.getValue();
    }

    public static void forBottomCorners(BoundingBox bb, Consumer<BlockPos> consumer) {
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        consumer.accept((BlockPos)mpos.m_122178_(bb.m_162399_(), bb.m_162396_(), bb.m_162401_()));
        consumer.accept((BlockPos)mpos.m_122178_(bb.m_162395_(), bb.m_162396_(), bb.m_162401_()));
        consumer.accept((BlockPos)mpos.m_122178_(bb.m_162399_(), bb.m_162396_(), bb.m_162398_()));
        consumer.accept((BlockPos)mpos.m_122178_(bb.m_162395_(), bb.m_162396_(), bb.m_162398_()));
    }
}

