/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.template;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.AbstractMnFeature;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.TemplateConfig;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BasicTemplateFeature<C extends TemplateConfig>
extends AbstractMnFeature<C> {
    public BasicTemplateFeature(Codec<C> codec) {
        super(codec);
    }

    @Override
    protected boolean place(WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos origin, C config) {
        StructureTemplateManager templateManager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = templateManager.m_230359_(((TemplateConfig)config).templates.get(rand.m_188503_(((TemplateConfig)config).templates.size())));
        if (template == null) {
            return false;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_230324_(rand);
        ChunkPos chunkPos = new ChunkPos(origin);
        Rotation rot = Rotation.m_221990_((RandomSource)rand);
        settings.m_74379_(rot).m_74381_(new BoundingBox(chunkPos.m_45604_() - 16, level.m_141937_(), chunkPos.m_45605_() - 16, chunkPos.m_45608_() + 16, level.m_151558_(), chunkPos.m_45609_() + 16));
        if (((TemplateConfig)config).ignoreAir) {
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }
        Optional processors = level.m_6018_().m_7654_().m_206579_().m_175515_(Registries.f_257011_).m_6612_(((TemplateConfig)config).processorList);
        processors.ifPresent(list -> list.m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)settings).m_74383_(arg_0)));
        Vec3i size = template.m_163808_(rot);
        BlockPos offset = origin.m_121955_((Vec3i)new BlockPos(-size.m_123341_() / 2, 0, -size.m_123343_() / 2));
        BlockPos templateZero = template.m_74583_(offset, Mirror.NONE, rot);
        templateZero = this.adjustPosition(level, template, templateZero, offset, origin, size, rot, config);
        return templateZero != null && template.m_230328_((ServerLevelAccessor)level, templateZero, templateZero, settings, rand, 3);
    }

    protected BlockPos adjustPosition(WorldGenLevel level, StructureTemplate template, BlockPos templateZero, BlockPos offset, BlockPos origin, Vec3i size, Rotation rot, C config) {
        return templateZero;
    }
}

