/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class TemplateConfig
implements FeatureConfiguration {
    public final List<ResourceLocation> templates;
    public final ResourceLocation processorList;
    public final boolean ignoreAir;
    public static final Codec<TemplateConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("templates").forGetter(config -> config.templates), (App)Codec.BOOL.fieldOf("ignore_air").forGetter(config -> config.ignoreAir), (App)ResourceLocation.f_135803_.fieldOf("processor_list").forGetter(config -> config.processorList)).apply((Applicative)instance, TemplateConfig::new));

    public TemplateConfig(ResourceLocation template, boolean ignoreAir, ResourceLocation processorList) {
        this(List.of(template), ignoreAir, processorList);
    }

    public TemplateConfig(String templatePrefix, int templateCount, boolean ignoreAir, ResourceLocation processorList) {
        this(IntStream.rangeClosed(1, templateCount).mapToObj(i -> String.format("%s_%d", templatePrefix, i)).map(i -> Midnight.id(i)).toList(), ignoreAir, processorList);
    }

    public TemplateConfig(List<ResourceLocation> templates, boolean ignoreAir, ResourceLocation processorList) {
        this.templates = templates;
        this.ignoreAir = ignoreAir;
        this.processorList = processorList;
    }
}

