/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockPileConfiguration;

public class SpikeFeature
extends Feature<BlockPileConfiguration> {
    public SpikeFeature(Codec<BlockPileConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockPileConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (BlockPileConfiguration)context.m_159778_());
    }

    private boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos origin, BlockPileConfiguration config) {
        while (!world.m_8055_(origin).m_60795_() && origin.m_123342_() > 2) {
            origin = origin.m_7495_();
        }
        origin = origin.m_6630_(rand.m_188503_(4));
        int height = rand.m_188503_(4) + 7;
        int baseRadius = Math.max(height / 4 + rand.m_188503_(2), 2);
        for (int y = 0; y < height; ++y) {
            float radius = (1.0f - (float)y / (float)height) * (float)baseRadius;
            int bound = Mth.m_14167_((float)radius);
            for (int x = -bound; x <= bound; ++x) {
                float deltaX = (float)Mth.m_14040_((int)x) - 0.25f;
                for (int z = -bound; z <= bound; ++z) {
                    BlockPos inversePos;
                    float deltaZ = (float)Mth.m_14040_((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(deltaX * deltaX + deltaZ * deltaZ <= radius * radius) || (x == -bound || x == bound || z == -bound || z == bound) && !(rand.m_188501_() <= 0.75f)) continue;
                    BlockPos pos = origin.m_7918_(x, y, z);
                    if (this.canReplace(world, pos)) {
                        this.m_5974_((LevelWriter)world, pos, config.f_67540_.m_213972_(rand, pos));
                    }
                    if (y == 0 || bound <= 1 || !this.canReplace(world, inversePos = origin.m_7918_(x, -y, z))) continue;
                    this.m_5974_((LevelWriter)world, inversePos, config.f_67540_.m_213972_(rand, inversePos));
                }
            }
        }
        return true;
    }

    private boolean canReplace(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60795_() || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_278411_);
    }
}

