/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.AbstractMnFeature;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.StateAndChanceConfig;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public abstract class PositionCheckingFeature<FC extends StateAndChanceConfig>
extends AbstractMnFeature<FC> {
    protected PositionCheckingFeature(Codec<FC> codec) {
        super(codec);
    }

    @Override
    protected boolean place(WorldGenLevel level, ChunkGenerator chunkGen, RandomSource rand, BlockPos origin, FC config) {
        List<BlockPos> positions = this.getPositions(origin, level, rand, config);
        if (positions == null || positions.isEmpty()) {
            return false;
        }
        positions.forEach(pos -> {
            if (rand.m_188501_() < config.chance) {
                BlockState state = config.stateProvider.m_213972_(rand, pos);
                if (state.m_60734_() instanceof DoublePlantBlock) {
                    if (level.m_46859_(pos.m_7494_())) {
                        DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)2);
                    }
                } else {
                    level.m_7731_(pos, state, 2);
                }
            }
        });
        return true;
    }

    protected abstract List<BlockPos> getPositions(BlockPos var1, WorldGenLevel var2, RandomSource var3, FC var4);
}

