/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.block.NightGrassBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.PitConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class PitFeature
extends Feature<PitConfig> {
    public PitFeature() {
        super(PitConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<PitConfig> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (PitConfig)context.m_159778_());
    }

    private boolean place(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos origin, PitConfig config) {
        float radius = config.radius().m_214085_(rand);
        origin = origin.m_6625_(1 + rand.m_188503_(2));
        origin = origin.m_6630_(Mth.m_14143_((float)(radius / 2.0f)));
        this.generateBlob(world, rand, origin, radius, config);
        for (int i = 0; i < 2; ++i) {
            int offsetX = rand.m_188503_(3) - 1;
            int offsetY = rand.m_188503_(2);
            int offsetZ = rand.m_188503_(3) - 1;
            BlockPos center = origin.m_7918_(offsetX, offsetY, offsetZ);
            radius = config.radius().m_214085_(rand);
            this.generateBlob(world, rand, center, radius, config);
        }
        return true;
    }

    private void generateBlob(WorldGenLevel world, RandomSource rand, BlockPos origin, float radius, PitConfig config) {
        float radiusSquare = radius * radius;
        int radiusCeil = Mth.m_14167_((float)radius);
        if (this.isSpace(world, rand, origin, radius)) {
            BlockPos minPos = origin.m_7918_(-radiusCeil, -radiusCeil, -radiusCeil);
            BlockPos maxPos = origin.m_7918_(radiusCeil, radiusCeil, radiusCeil);
            BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
                double distSquare = pos.m_123331_((Vec3i)origin);
                if (distSquare <= (double)radiusSquare && world.m_8055_(pos) != Blocks.f_49990_.m_49966_()) {
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    if (world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos.m_7495_())) {
                        this.m_5974_((LevelWriter)world, pos.m_7495_(), ((NightGrassBlock)((Object)((Object)MnBlocks.NIGHT_GRASS_BLOCK.get()))).m_49966_());
                    }
                }
            });
        }
    }

    private boolean isSpace(WorldGenLevel world, RandomSource rand, BlockPos origin, float radius) {
        float radiusSquare = radius * radius;
        int radiusCeil = Mth.m_14167_((float)radius);
        BlockPos minPos = origin.m_7918_(-radiusCeil, -radiusCeil, -radiusCeil);
        BlockPos maxPos = origin.m_7918_(radiusCeil, radiusCeil, radiusCeil);
        return BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).filter(pos -> pos.m_123331_((Vec3i)origin) <= (double)radiusSquare).allMatch(pos -> world.m_8055_(pos.m_7495_()).m_60819_().m_76178_());
    }
}

