/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.PositionCheckingFeature;
import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.StateAndChanceConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;

public class MalignantPatchFeature
extends PositionCheckingFeature<StateAndChanceConfig> {
    public MalignantPatchFeature() {
        super(StateAndChanceConfig.CODEC);
    }

    @Override
    protected List<BlockPos> getPositions(BlockPos origin, WorldGenLevel level, RandomSource rand, StateAndChanceConfig config) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        origin = origin.m_7495_();
        int defaultRadius = 6;
        float wobbleStrength = 1.7f;
        int numSpikes = 9;
        float startAngle = rand.m_188501_() * ((float)Math.PI * 2);
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int localX = -defaultRadius; localX <= defaultRadius; ++localX) {
            for (int localZ = -defaultRadius; localZ <= defaultRadius; ++localZ) {
                basePos.m_122178_(origin.m_123341_() + localX, origin.m_123342_(), origin.m_123343_() + localZ);
                double distSquare = basePos.m_123331_((Vec3i)origin);
                float radiusVariation = wobbleStrength + wobbleStrength * Mth.m_14031_((float)(startAngle + (float)numSpikes * (float)Math.atan2(localZ, localX)));
                float radius = (float)defaultRadius - radiusVariation;
                if (!(distSquare <= (double)(radius * radius))) continue;
                BlockPos toPlacePos = this.canPlace((BlockPos)basePos, level);
                if (toPlacePos == null) {
                    return null;
                }
                validPositions.add(toPlacePos);
            }
        }
        return validPositions;
    }

    private BlockPos canPlace(BlockPos origin, WorldGenLevel level) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (int y = origin.m_123342_() + 1; y > origin.m_123342_() - 2; --y) {
            mPos.m_142448_(y);
            if (!level.m_46859_(mPos.m_7494_()) || !level.m_8055_((BlockPos)mPos).m_60838_((BlockGetter)level, (BlockPos)mPos)) continue;
            return mPos;
        }
        return null;
    }
}

