/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.feature;

import com.crypticmushroom.minecraft.midnight.common.world.gen.feature.config.DeadLogFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class DeadLogFeature
extends Feature<DeadLogFeatureConfig> {
    public DeadLogFeature() {
        super(DeadLogFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<DeadLogFeatureConfig> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (DeadLogFeatureConfig)context.m_159778_());
    }

    private boolean place(WorldGenLevel level, ChunkGenerator gen, RandomSource rand, BlockPos pos, DeadLogFeatureConfig config) {
        int lenMinL = config.getLengthMin();
        int lenMaxL = config.getLengthMax();
        int lenMin = Math.min(lenMinL, lenMaxL);
        int lenMax = Math.max(lenMinL, lenMaxL);
        BlockState xState = config.getXAxisLog().m_213972_(rand, pos);
        BlockState zState = config.getZAxisLog().m_213972_(rand, pos);
        int len = rand.m_188503_(lenMax - lenMin + 1) + lenMin;
        Direction dir = rand.m_188499_() ? Direction.EAST : Direction.SOUTH;
        BlockPos off = pos.m_5484_(dir, -len / 2);
        return this.generate(level, off, rand, config.getBranchingChance(), config.getBranchLengthMax(), len, dir == Direction.EAST ? xState : zState, dir == Direction.EAST ? zState : xState, dir);
    }

    protected boolean generate(WorldGenLevel world, BlockPos pos, RandomSource rand, int branchChance, int branchLenMax, int len, BlockState state, BlockState oppositeAxis, Direction dir) {
        int i;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        for (i = 0; i < len; ++i) {
            BlockState medium = world.m_8055_((BlockPos)mpos);
            if (!this.isValidMedium(world, (BlockPos)mpos, medium)) {
                return false;
            }
            mpos.m_122173_(Direction.DOWN);
            BlockState ground = world.m_8055_((BlockPos)mpos);
            if (!this.isValidGround(world, (BlockPos)mpos, ground)) {
                return false;
            }
            mpos.m_122173_(Direction.UP);
            mpos.m_122173_(dir);
        }
        mpos.m_122190_((Vec3i)pos);
        for (i = 0; i < len; ++i) {
            world.m_7731_((BlockPos)mpos, state, 2);
            if (branchChance > 0 && branchLenMax > 0 && rand.m_188503_(branchChance) == 0) {
                int branchLen = rand.m_188503_(rand.m_188503_(branchLenMax + 1) + 1) + 1;
                Direction branchDir = rand.m_188499_() ? dir.m_122428_() : dir.m_122427_();
                BlockPos branchPos = mpos.m_7949_().m_121945_(branchDir);
                this.generate(world, branchPos, rand, 0, 0, branchLen, oppositeAxis, state, branchDir);
            }
            mpos.m_122173_(dir);
        }
        return true;
    }

    protected boolean isValidGround(WorldGenLevel world, BlockPos pos, BlockState state) {
        return state.m_60783_((BlockGetter)world, pos, Direction.UP);
    }

    protected boolean isValidMedium(WorldGenLevel world, BlockPos pos, BlockState state) {
        return state.m_278721_() || !state.m_280555_() || state.m_204336_(BlockTags.f_13035_);
    }
}

